/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Group;
import org.simantics.scenegraph.profile.ProfileEntry;
import org.simantics.scenegraph.profile.Style;
import org.simantics.utils.ui.ErrorLogger;

public class GroupStyleProfileEntry
implements ProfileEntry {
    private final Resource entry;
    private boolean active = false;
    private Style style;
    private Group group;
    private double priority;

    public GroupStyleProfileEntry(ReadGraph graph, Resource entry) throws DatabaseException {
        this.entry = entry;
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        Resource style = graph.getPossibleObject(entry, dr.ProfileEntry_HasStyle);
        Resource group = graph.getPossibleObject(entry, dr.ProfileEntry_HasGroup);
        Double priority = (Double)graph.getPossibleRelatedValue(entry, dr.ProfileEntry_HasPriority);
        this.priority = priority != null ? priority : 0.0;
        this.style = (Style)graph.adapt(style, Style.class);
        this.style.setPriority(this.priority);
        this.group = (Group)graph.adapt(group, Group.class);
    }

    public void activate(RequestProcessor processor, final Resource runtimeDiagram, final EvaluationContext observer) {
        try {
            processor.syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    GroupStyleProfileEntry.this.style.activate((RequestProcessor)graph, runtimeDiagram, GroupStyleProfileEntry.this.entry, GroupStyleProfileEntry.this.group, observer);
                }
            });
            this.active = true;
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
    }

    public void deactivate(Resource diagram, EvaluationContext observer) {
        if (this.style == null) {
            System.out.println("GroupStyleProfileEntry has null style!");
            return;
        }
        this.style.deactivate(diagram, this.entry, this.group, observer);
        this.active = false;
    }

    public void apply(EvaluationContext observer) {
        if (this.style == null) {
            System.out.println("GroupStyleProfileEntry has null style!");
            return;
        }
        this.style.apply(this.entry, this.group, observer);
    }

    public int hashCode() {
        return this.entry.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (GroupStyleProfileEntry.class != object.getClass()) {
            return false;
        }
        GroupStyleProfileEntry other = (GroupStyleProfileEntry)object;
        return this.entry.equals(other.entry);
    }

    public String toString() {
        return String.valueOf(this.style) + " applied to " + String.valueOf(this.group);
    }

    public boolean isActive() {
        return this.active;
    }

    public double getPriority() {
        return this.priority;
    }
}

