/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.Adapter;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.diagram.adapter.BaseRequest2;
import org.simantics.diagram.adapter.ElementFactory;
import org.simantics.diagram.adapter.GetElementClassRequest;
import org.simantics.diagram.adapter.LoadRequest;
import org.simantics.diagram.adapter.SpawnRequest;
import org.simantics.diagram.synchronization.ErrorHandler;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.IElement;

public class ConnectionRequest
extends BaseRequest2<Resource, IElement> {
    final IDiagram diagram;
    final Listener<IElement> loadListener;
    final ErrorHandler errorHandler;

    public ConnectionRequest(ICanvasContext canvas, IDiagram diagram, Resource resource, ErrorHandler errorHandler, Listener<IElement> loadListener) {
        super(canvas, resource);
        this.diagram = diagram;
        this.errorHandler = errorHandler;
        this.loadListener = loadListener;
    }

    public void perform(AsyncReadGraph graph, final AsyncProcedure<IElement> procedure) {
        graph.forHasStatement((Resource)this.data, (AsyncProcedure)new AsyncProcedure<Boolean>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }

            public void execute(AsyncReadGraph graph, Boolean result) {
                if (!result.booleanValue()) {
                    procedure.execute(graph, null);
                    return;
                }
                graph.asyncRequest((Read)new Adapter((Resource)ConnectionRequest.this.data, ElementFactory.class), (AsyncListener)new TransientCacheAsyncListener<ElementFactory>(){

                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        (this).ConnectionRequest.this.errorHandler.error("Unexpected ElementFactory adaption failure", throwable);
                        procedure.execute(graph, null);
                    }

                    public void execute(AsyncReadGraph graph, final ElementFactory factory) {
                        graph.asyncRequest((AsyncRead)new GetElementClassRequest(factory, (Resource)(this).ConnectionRequest.this.data, (this).ConnectionRequest.this.canvas, (this).ConnectionRequest.this.diagram), (AsyncListener)new TransientCacheAsyncListener<ElementClass>(){

                            public void exception(AsyncReadGraph graph, Throwable throwable) {
                                ((this).this).ConnectionRequest.this.errorHandler.error("Unexpected ElementClass creation failure", throwable);
                                procedure.execute(graph, null);
                            }

                            public void execute(AsyncReadGraph graph, ElementClass ec) {
                                if (((this).this).ConnectionRequest.this.loadListener != null) {
                                    graph.asyncRequest((AsyncRead)new LoadRequest(((this).this).ConnectionRequest.this.canvas, ((this).this).ConnectionRequest.this.diagram, factory, ec, (Resource)((this).this).ConnectionRequest.this.data), (AsyncListener)new ConnectionRequestListener(((this).this).ConnectionRequest.this.loadListener, (AsyncProcedure<IElement>)procedure));
                                } else {
                                    graph.asyncRequest((AsyncRead)new SpawnRequest(((this).this).ConnectionRequest.this.canvas, ec, (Resource)((this).this).ConnectionRequest.this.data), (AsyncListener)new TransientCacheAsyncListener<IElement>(){

                                        public void exception(AsyncReadGraph graph, Throwable throwable) {
                                            (((this).this).this).ConnectionRequest.this.errorHandler.error("Unexpected SpawnRequest failure", throwable);
                                            procedure.exception(graph, throwable);
                                        }

                                        public void execute(AsyncReadGraph graph, IElement element) {
                                            procedure.execute(graph, (Object)element);
                                            factory.load(graph, (((this).this).this).ConnectionRequest.this.canvas, (((this).this).this).ConnectionRequest.this.diagram, (Resource)(((this).this).this).ConnectionRequest.this.data, element, new AsyncProcedure<IElement>(){

                                                public void exception(AsyncReadGraph graph, Throwable throwable) {
                                                    ((((this).this).this).this).ConnectionRequest.this.errorHandler.error("Unexpected ElementFactory.load failure", throwable);
                                                }

                                                public void execute(AsyncReadGraph graph, IElement result) {
                                                }
                                            });
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    private static class ConnectionRequestListener
    implements AsyncListener<IElement> {
        private Listener<IElement> loadListener;
        private AsyncProcedure<IElement> procedure;

        ConnectionRequestListener(Listener<IElement> loadListener, AsyncProcedure<IElement> procedure) {
            this.loadListener = loadListener;
            this.procedure = procedure;
        }

        public void execute(AsyncReadGraph graph, IElement result) {
            this.loadListener.execute((Object)result);
            if (this.procedure != null) {
                this.procedure.execute(graph, (Object)result);
                this.procedure = null;
            }
        }

        public void exception(AsyncReadGraph graph, Throwable t) {
            this.loadListener.exception(t);
            if (this.procedure != null) {
                this.procedure.exception(graph, t);
                this.procedure = null;
            }
        }

        public boolean isDisposed() {
            return this.loadListener.isDisposed();
        }
    }
}

