/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import java.util.Collection;
import java.util.Iterator;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.ModificationAdapter;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;

public class RemoveBranchpoint
extends ModificationAdapter {
    Resource element;

    public RemoveBranchpoint(IElement element) {
        super(REMOVE_BRANCH_PRIORITY);
        this.element = (Resource)element.getHint(ElementHints.KEY_OBJECT);
        assert (element != null);
    }

    @Override
    public void perform(WriteGraph g) throws DatabaseException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
        Collection connectors = g.getObjects(this.element, dr.AreConnected);
        ConnectionUtil cu = new ConnectionUtil(g);
        cu.removeConnectionPart(this.element);
        if (connectors.size() == 2) {
            Iterator it = connectors.iterator();
            Resource c1 = (Resource)it.next();
            Resource c2 = (Resource)it.next();
            cu.connect(c1, c2);
        }
    }
}

