/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.diagram.synchronization.ModificationAdapter;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;

public class ElementReorder
extends ModificationAdapter {
    IDiagram diagram;
    List<IElement> order;

    public ElementReorder(IDiagram diagram, List<IElement> order) {
        super(LOW_PRIORITY);
        this.diagram = diagram;
        this.order = order;
    }

    @Override
    public void perform(WriteGraph g) throws Exception {
        Resource l = (Resource)this.diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
        List graphOrder = OrderedSetUtils.toList((ReadGraph)g, (Resource)l);
        HashSet graphContents = new HashSet(graphOrder);
        ArrayList<Resource> newGraphOrder = new ArrayList<Resource>();
        for (IElement e : this.order) {
            Resource r;
            Object obj = ElementUtils.getObject((IElement)e);
            if (!(obj instanceof Resource) || !graphContents.contains(r = (Resource)obj)) continue;
            newGraphOrder.add(r);
        }
        if (graphOrder.size() != newGraphOrder.size()) {
            HashSet added = new HashSet(newGraphOrder);
            for (Resource r : graphOrder) {
                if (added.contains(r)) continue;
                newGraphOrder.add(r);
            }
        }
        OrderedSetUtils.reorder((WriteGraph)g, (Resource)l, newGraphOrder);
    }
}

