/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import gnu.trove.set.hash.THashSet;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.datatypes.literal.Vec2d;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.primitiverequest.OrderedSet;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.Queries;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.DoesNotContainValueException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncMultiRead;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.diagram.connection.ConnectionSegmentEnd;
import org.simantics.diagram.connection.ConnectionVisuals;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.content.DesignatedTerminal;
import org.simantics.diagram.content.ElementContext;
import org.simantics.diagram.content.ResourceTerminal;
import org.simantics.diagram.content.TerminalMap;
import org.simantics.diagram.internal.DebugPolicy;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.BasicResources;
import org.simantics.g2d.connection.EdgeVisualsConfigurer;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.handler.FillColor;
import org.simantics.g2d.element.handler.TerminalTopology;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.g2d.page.DiagramDesc;
import org.simantics.g2d.routing.IRouter2;
import org.simantics.g2d.svg.LineCap;
import org.simantics.g2d.svg.LineJoin;
import org.simantics.g2d.utils.Alignment;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.binaryPredicates.OrderedSetElementsPredicate;
import org.simantics.modeling.ModelingResources;
import org.simantics.scl.commands.Commands;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.modelingRules.CPTerminal;
import org.simantics.structural2.modelingRules.IAttachmentRelationMap;
import org.simantics.structural2.modelingRules.IConnectionPoint;
import org.simantics.structural2.modelingRules.IModelingRules;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.simantics.utils.page.MarginUtils;
import org.simantics.utils.page.PageCentering;
import org.simantics.utils.page.PageDesc;
import org.simantics.utils.page.PageOrientation;
import org.simantics.utils.ui.ErrorLogger;

public final class DiagramGraphUtil {
    private static final boolean DEBUG_GET_ELEMENT_TYPE_TERMINALS = false;

    public static double[] validateAffineTransform(Resource resource, double[] matrix) {
        if (matrix != null) {
            if (matrix.length < 4) {
                ErrorLogger.defaultLogError((String)("resource " + String.valueOf(resource) + " matrix too small for AffineTransform: " + Arrays.toString(matrix)), (Throwable)new Exception("trace"));
                return null;
            }
            if (DebugPolicy.DEBUG_TRANSFORM_LOAD) {
                double det = new AffineTransform(matrix).getDeterminant();
                double detabs = Math.abs(det);
                if (detabs < DebugPolicy.DETERMINANT_LIMIT_LOW) {
                    ErrorLogger.defaultLogWarning((String)("resource " + String.valueOf(resource) + " transform determinant absolute value is close to zero: " + detabs + "(transform=" + Arrays.toString(matrix) + ")"), (Throwable)new Exception("trace"));
                }
                if (detabs > DebugPolicy.DETERMINANT_LIMIT_HIGH) {
                    ErrorLogger.defaultLogWarning((String)("resource " + String.valueOf(resource) + " transform determinant absolute value is suspiciously large: " + detabs + "(transform=" + Arrays.toString(matrix) + ")"), (Throwable)new Exception("trace"));
                }
            }
            if (matrix.length > 5) {
                boolean largeY;
                double xabs = Math.abs(matrix[4]);
                double yabs = Math.abs(matrix[5]);
                double limit = DebugPolicy.TRANSLATION_LIMIT_HIGH;
                boolean largeX = xabs > limit;
                boolean bl = largeY = yabs > limit;
                if (largeX || largeY) {
                    ErrorLogger.defaultLogWarning((String)("resource " + String.valueOf(resource) + " transform translation is suspiciously large: " + Arrays.toString(matrix)), (Throwable)new Exception("trace"));
                }
                return matrix;
            }
        }
        return matrix;
    }

    public static AffineTransform getAffineTransform(ReadGraph graph, Resource resource) throws DatabaseException {
        G2DResource g2d = G2DResource.getInstance((ReadGraph)graph);
        return DiagramGraphUtil.getAffineTransform(graph, resource, g2d.HasTransform, true);
    }

    public static Vec2d getOffset(ReadGraph graph, Resource resource) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Vec2d offset = (Vec2d)graph.getPossibleRelatedValue(resource, DIA.Element_profileMonitorOffset, Vec2d.BINDING);
        if (offset != null) {
            return offset;
        }
        return new Vec2d(0.0, 0.0);
    }

    public static boolean getProfileMonitorsHidden(ReadGraph graph, Resource resource) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Boolean value = (Boolean)graph.getPossibleRelatedValue(resource, DIA.Element_hideProfileMonitors, (Binding)Bindings.BOOLEAN);
        if (value == null) {
            value = false;
        }
        return value;
    }

    public static boolean getProfileMonitorsUp(ReadGraph graph, Resource resource) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Boolean value = (Boolean)graph.getPossibleRelatedValue(resource, DIA.Element_upProfileMonitors, (Binding)Bindings.BOOLEAN);
        if (value == null) {
            value = true;
        }
        return value;
    }

    public static double getProfileMonitorSpacing(ReadGraph graph, Resource resource) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Double value = (Double)graph.getPossibleRelatedValue(resource, DIA.Element_profileMonitorSpacing, (Binding)Bindings.DOUBLE);
        if (value == null) {
            value = 0.0;
        }
        return value;
    }

    public static AffineTransform getDynamicAffineTransform(ReadGraph graph, Resource runtime, Resource element) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        return DiagramGraphUtil.getDynamicAffineTransform(graph, runtime, element, DIA.HasDynamicTransform, true);
    }

    public static AffineTransform getWorldTransform(ReadGraph graph, Resource element) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        AffineTransform result = DiagramGraphUtil.getAffineTransform(graph, element);
        Resource parentComponent;
        while ((parentComponent = graph.getPossibleObject(element, MOD.HasParentComponent)) != null) {
            element = graph.getPossibleObject(parentComponent, MOD.ComponentToElement);
            if (element == null) {
                return result;
            }
            AffineTransform tr = DiagramGraphUtil.getAffineTransform(graph, element);
            tr.setToTranslation(tr.getTranslateX(), tr.getTranslateY());
            result.preConcatenate(tr);
        }
        return result;
    }

    public static AffineTransform getDynamicWorldTransform(ReadGraph graph, Resource runtime, Resource element) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        AffineTransform result = DiagramGraphUtil.getDynamicAffineTransform(graph, runtime, element);
        Resource parentComponent;
        while ((parentComponent = graph.getPossibleObject(element, MOD.HasParentComponent)) != null) {
            element = graph.getPossibleObject(parentComponent, MOD.ComponentToElement);
            if (element == null) {
                return result;
            }
            AffineTransform tr = DiagramGraphUtil.getDynamicAffineTransform(graph, runtime, element);
            tr.setToTranslation(tr.getTranslateX(), tr.getTranslateY());
            result.preConcatenate(tr);
        }
        return result;
    }

    public static AffineTransform getAffineTransform(ReadGraph graph, Resource resource, Resource relation, boolean invalidAsIdentity) throws DatabaseException {
        double[] mat = DiagramGraphUtil.getPossibleRelatedDoubleArray(graph, resource, relation);
        return (mat = DiagramGraphUtil.validateAffineTransform(resource, mat)) != null ? new AffineTransform(mat) : (invalidAsIdentity ? new AffineTransform() : null);
    }

    public static AffineTransform getDynamicAffineTransform(ReadGraph graph, Resource runtime, Resource element, Resource relation, boolean invalidAsIdentity) throws DatabaseException {
        double[] mat = (double[])graph.getPossibleRelatedValue2(element, relation, (Object)new ElementContext(runtime, element), (Binding)Bindings.DOUBLE_ARRAY);
        return (mat = DiagramGraphUtil.validateAffineTransform(element, mat)) != null ? new AffineTransform(mat) : (invalidAsIdentity ? new AffineTransform() : null);
    }

    public static double[] getPossibleRelatedDoubleArray(ReadGraph graph, Resource resource, Resource relation) throws DatabaseException {
        Resource res = graph.getPossibleObject(resource, relation);
        if (res == null) {
            return null;
        }
        return (double[])graph.getValue(res, Bindings.getBindingUnchecked(double[].class));
    }

    public static AffineTransform getTransform(ReadGraph graph, Resource resource) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        double[] matrix = (double[])graph.getPossibleRelatedValue(resource, DIA.HasTransform, (Binding)Bindings.DOUBLE_ARRAY);
        if (matrix == null) {
            return new AffineTransform();
        }
        if (matrix.length < 4) {
            return new AffineTransform();
        }
        return new AffineTransform(matrix);
    }

    public static void setTransform(WriteGraph graph, Resource resource, AffineTransform at) throws DatabaseException {
        double[] matrix = new double[6];
        at.getMatrix(matrix);
        DiagramGraphUtil.changeTransform(graph, resource, matrix);
    }

    public static void setTransform(WriteGraph graph, Resource resource, double[] matrix) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        G2DResource G2D = G2DResource.getInstance((ReadGraph)graph);
        DiagramGraphUtil.setRelatedValue(graph, resource, DIA.HasTransform, G2D.Transform, matrix, (Binding)Bindings.DOUBLE_ARRAY);
    }

    public static void changeTransform(WriteGraph graph, Resource resource, AffineTransform at) throws DatabaseException {
        double[] matrix = new double[6];
        at.getMatrix(matrix);
        DiagramGraphUtil.changeTransform(graph, resource, matrix);
    }

    public static void changeTransform(WriteGraph graph, Resource resource, double[] matrix) throws DatabaseException {
        Commands.get((ReadGraph)graph, (String)"Simantics/Diagram/setTransform").execute((RequestProcessor)graph, (Resource)graph.syncRequest((Read)new IndexRoot(resource)), new Object[]{resource, matrix});
    }

    public static void setRelatedValue(WriteGraph graph, Resource resource, Resource relation, Resource valueType, Object arrayValue, Binding binding) throws DatabaseException {
        Statement stm = graph.getPossibleStatement(resource, relation);
        if (stm == null) {
            DiagramGraphUtil.addRelatedValue(graph, resource, relation, valueType, arrayValue, binding);
        } else if (!stm.getSubject().equals(resource)) {
            DiagramGraphUtil.addRelatedValue(graph, resource, relation, valueType, arrayValue, binding);
        } else {
            graph.claimValue(stm.getObject(), arrayValue, binding);
        }
    }

    public static Resource addRelatedValue(WriteGraph graph, Resource resource, Resource relation, Resource valueType, Object arrayValue, Binding binding) throws DatabaseException {
        Resource d = graph.newResource();
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        graph.claim(d, b.InstanceOf, null, valueType);
        graph.claimValue(d, arrayValue);
        graph.claim(resource, relation, d);
        return d;
    }

    public static <T> T getPossibleRelatedValue(ReadGraph graph, Resource r, Resource relation, Class<T> valueClass, T defaultValue) throws DatabaseException {
        Resource object = graph.getPossibleObject(r, relation);
        if (object == null) {
            return defaultValue;
        }
        Object t = graph.getPossibleValue(object, Bindings.getBindingUnchecked(valueClass));
        if (t != null && valueClass.isArray() && defaultValue != null) {
            int defaultValueLength = Array.getLength(defaultValue);
            int valueLength = Array.getLength(t);
            if (valueLength < defaultValueLength) {
                return defaultValue;
            }
        }
        return (T)(t == null ? defaultValue : t);
    }

    public static Resource getConnectionPointOfTerminal(ReadGraph g, Topology.Terminal forTerminal) throws DatabaseException {
        if (forTerminal instanceof ResourceTerminal) {
            return DiagramGraphUtil.getConnectionPointOfTerminal(g, ((ResourceTerminal)forTerminal).getResource());
        }
        return null;
    }

    public static Resource tryGetBindingRelation(ReadGraph g, Topology.Terminal forTerminal) throws DatabaseException {
        if (forTerminal instanceof ResourceTerminal) {
            return DiagramGraphUtil.getPossibleConnectionPointOfTerminal(g, ((ResourceTerminal)forTerminal).getResource());
        }
        return null;
    }

    public static LineJoin toLineJoin(G2DResource g2d, Resource lineJoin) {
        if (lineJoin != null) {
            if (lineJoin.equals(g2d.LineJoin_BevelJoin)) {
                return LineJoin.bevel;
            }
            if (lineJoin.equals(g2d.LineJoin_RoundJoin)) {
                return LineJoin.round;
            }
        }
        return LineJoin.miter;
    }

    public static LineCap toLineCap(G2DResource g2d, Resource lineCap) {
        if (lineCap != null) {
            if (lineCap.equals(g2d.LineCap_ButtCap)) {
                return LineCap.butt;
            }
            if (lineCap.equals(g2d.LineCap_RoundCap)) {
                return LineCap.round;
            }
        }
        return LineCap.square;
    }

    public static Resource toLineJoin(G2DResource g2d, LineJoin lineJoin) {
        if (lineJoin != null) {
            if (lineJoin.equals((Object)LineJoin.bevel)) {
                return g2d.LineJoin_BevelJoin;
            }
            if (lineJoin.equals((Object)LineJoin.round)) {
                return g2d.LineJoin_RoundJoin;
            }
        }
        return g2d.LineJoin_MiterJoin;
    }

    public static Resource toLineCap(G2DResource g2d, LineCap lineCap) {
        if (lineCap != null) {
            if (lineCap.equals((Object)LineCap.butt)) {
                return g2d.LineCap_ButtCap;
            }
            if (lineCap.equals((Object)LineCap.round)) {
                return g2d.LineCap_RoundCap;
            }
        }
        return g2d.LineCap_SquareCap;
    }

    public static Alignment toAlignment(Resource align, G2DResource g2d, Alignment defaultValue) {
        if (align == null) {
            return defaultValue;
        }
        if (align.equals(g2d.Alignment_Leading)) {
            return Alignment.LEADING;
        }
        if (align.equals(g2d.Alignment_Trailing)) {
            return Alignment.TRAILING;
        }
        if (align.equals(g2d.Alignment_Center)) {
            return Alignment.CENTER;
        }
        return defaultValue;
    }

    public static Alignment toVerticalAlignment(Resource align, G2DResource g2d, Alignment defaultValue) {
        if (align == null) {
            return defaultValue;
        }
        if (align.equals(g2d.Alignment_Leading)) {
            return Alignment.LEADING;
        }
        if (align.equals(g2d.Alignment_Trailing)) {
            return Alignment.TRAILING;
        }
        if (align.equals(g2d.Alignment_Center)) {
            return Alignment.CENTER;
        }
        if (align.equals(g2d.Alignment_Baseline)) {
            return Alignment.BASELINE;
        }
        return defaultValue;
    }

    public static Resource toFlagTypeResource(DiagramResource dr, FlagClass.Type type) {
        switch (type) {
            case In: {
                return dr.FlagType_InputFlag;
            }
            case Out: {
                return dr.FlagType_OutputFlag;
            }
        }
        throw new IllegalArgumentException("unsupported flag type: " + String.valueOf(type));
    }

    public static FlagClass.Type toFlagType(DiagramResource dr, Resource type) {
        return DiagramGraphUtil.toFlagType(dr, type, FlagClass.Type.In);
    }

    public static FlagClass.Type toFlagType(DiagramResource dr, Resource type, FlagClass.Type defaultValue) {
        if (type != null) {
            if (dr.FlagType_InputFlag.equals(type)) {
                return FlagClass.Type.In;
            }
            if (dr.FlagType_OutputFlag.equals(type)) {
                return FlagClass.Type.Out;
            }
        }
        return defaultValue;
    }

    public static void tag(WriteGraph g, Resource object, Resource tag, boolean set) throws DatabaseException {
        if (set) {
            g.claim(object, tag, tag, object);
        } else {
            g.deny(object, tag, tag, object);
        }
    }

    public static PageDesc getPageDesc(ReadGraph graph, Resource diagram, PageDesc defaultValue) throws DatabaseException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        Resource pd = graph.getPossibleObject(diagram, dr.HasPageDescription);
        if (pd == null) {
            return defaultValue;
        }
        return DiagramGraphUtil.readPageDesc(graph, pd);
    }

    public static PageDesc getPageDesc(ReadGraph graph, Resource diagram) throws DatabaseException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        Resource pd = graph.getSingleObject(diagram, dr.HasPageDescription);
        return DiagramGraphUtil.readPageDesc(graph, pd);
    }

    public static PageDesc readPageDesc(ReadGraph graph, Resource pageDesc) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        Resource orientation = graph.getSingleObject(pageDesc, dr.PageDescription_Orientation);
        double[] size = (double[])graph.getRelatedValue(pageDesc, dr.PageDescription_Size, Bindings.getBindingUnchecked(double[].class));
        Resource margins = graph.getSingleObject(pageDesc, dr.PageDescription_Margins);
        MarginUtils.Margins m = DiagramGraphUtil.readMargins(graph, margins);
        String name = (String)graph.getPossibleRelatedValue(pageDesc, l0.HasName);
        if (name == null) {
            name = "";
        }
        Resource centering = graph.getSingleObject(pageDesc, dr.PageDescription_PageCentering);
        PageDesc pd = new PageDesc(name, DiagramGraphUtil.toOrientation(orientation, dr), DiagramGraphUtil.toCentering(centering, dr, PageCentering.TopLeftAtOrigin), size[0], size[1], m);
        return pd;
    }

    public static MarginUtils.Margins readMargins(ReadGraph graph, Resource margins) throws NoSingleResultException, DoesNotContainValueException, ServiceException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        double t = (Double)graph.getRelatedValue(margins, dr.PageDescription_Margins_Top);
        double b = (Double)graph.getRelatedValue(margins, dr.PageDescription_Margins_Bottom);
        double l = (Double)graph.getRelatedValue(margins, dr.PageDescription_Margins_Left);
        double r = (Double)graph.getRelatedValue(margins, dr.PageDescription_Margins_Right);
        MarginUtils.Margin mt = new MarginUtils.Margin(0.0, 0.0, t);
        MarginUtils.Margin mb = new MarginUtils.Margin(0.0, 0.0, b);
        MarginUtils.Margin ml = new MarginUtils.Margin(0.0, 0.0, l);
        MarginUtils.Margin mr = new MarginUtils.Margin(0.0, 0.0, r);
        return new MarginUtils.Margins(mt, mb, ml, mr);
    }

    public static void setPageDesc(WriteGraph graph, Resource diagram, String pageDescRepr) throws DatabaseException {
        DiagramGraphUtil.setPageDesc(graph, diagram, PageDesc.fromRepr((String)pageDescRepr));
    }

    public static void setPageDesc(WriteGraph graph, Resource diagram, PageDesc pageDesc) throws DatabaseException {
        Layer0 b = Layer0.getInstance((ReadGraph)graph);
        G2DResource g2d = G2DResource.getInstance((ReadGraph)graph);
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        Resource pd = graph.getPossibleObject(diagram, dr.HasPageDescription);
        if (pd != null && graph.isImmutable(pd)) {
            graph.deny(diagram, dr.HasPageDescription);
            pd = null;
        }
        if (pd == null) {
            pd = graph.newResource();
            graph.claim(pd, b.InstanceOf, null, dr.PageDescription);
            graph.claim(diagram, dr.HasPageDescription, pd);
        }
        graph.deny(pd, dr.PageDescription_Size);
        Resource pageSize = graph.newResource();
        graph.claim(pageSize, b.InstanceOf, null, g2d.Point2D);
        graph.claimValue(pageSize, (Object)new double[]{pageDesc.getWidth(), pageDesc.getHeight()});
        graph.claim(pd, dr.PageDescription_Size, pageSize);
        graph.deny(pd, dr.PageDescription_Orientation);
        graph.claim(pd, dr.PageDescription_Orientation, DiagramGraphUtil.toOrientationResource(pageDesc.getOrientation(), dr));
        graph.deny(pd, dr.PageDescription_PageCentering);
        graph.claim(pd, dr.PageDescription_PageCentering, DiagramGraphUtil.toCenteringResource(pageDesc.getCentering(), dr));
        Resource margins = graph.getPossibleObject(pd, dr.PageDescription_Margins);
        if (margins == null) {
            margins = graph.newResource();
            graph.claim(margins, b.InstanceOf, null, dr.Margins);
            graph.claim(pd, dr.PageDescription_Margins, margins);
        }
        DiagramGraphUtil.setMargins(graph, pageDesc.getMargins(), margins, dr);
        graph.claimLiteral(pd, b.HasName, (Object)pageDesc.getText());
    }

    private static PageOrientation toOrientation(Resource orientation, DiagramResource dr) {
        if (orientation != null) {
            if (orientation.equals(dr.Orientation_Portrait)) {
                return PageOrientation.Portrait;
            }
            if (orientation.equals(dr.Orientation_Landscape)) {
                return PageOrientation.Landscape;
            }
        }
        return PageOrientation.Portrait;
    }

    public static Resource toOrientationResource(PageOrientation orientation, DiagramResource dr) {
        if (PageOrientation.Portrait.equals((Object)orientation)) {
            return dr.Orientation_Portrait;
        }
        if (PageOrientation.Landscape.equals((Object)orientation)) {
            return dr.Orientation_Landscape;
        }
        return dr.Orientation_Portrait;
    }

    private static PageCentering toCentering(Resource type, DiagramResource dr, PageCentering defaultValue) {
        if (type != null) {
            if (dr.PageCentering_CenteredAroundOrigin.equals(type)) {
                return PageCentering.CenteredAroundOrigin;
            }
            if (dr.PageCentering_TopLeftAtOrigin.equals(type)) {
                return PageCentering.TopLeftAtOrigin;
            }
        }
        return defaultValue;
    }

    public static Resource toCenteringResource(PageCentering centering, DiagramResource dr) {
        if (PageCentering.TopLeftAtOrigin.equals((Object)centering)) {
            return dr.PageCentering_TopLeftAtOrigin;
        }
        if (PageCentering.CenteredAroundOrigin.equals((Object)centering)) {
            return dr.PageCentering_CenteredAroundOrigin;
        }
        return dr.PageCentering_TopLeftAtOrigin;
    }

    private static void setMargins(WriteGraph g, MarginUtils.Margins margins, Resource marginsR, DiagramResource dr) throws ServiceException, ManyObjectsForFunctionalRelationException {
        g.claimLiteral(marginsR, dr.PageDescription_Margins_Top, (Object)margins.top.diagramAbsolute);
        g.claimLiteral(marginsR, dr.PageDescription_Margins_Bottom, (Object)margins.bottom.diagramAbsolute);
        g.claimLiteral(marginsR, dr.PageDescription_Margins_Left, (Object)margins.left.diagramAbsolute);
        g.claimLiteral(marginsR, dr.PageDescription_Margins_Right, (Object)margins.right.diagramAbsolute);
    }

    public static Double getGridSize(ReadGraph graph, Resource diagram, Double defaultValue) throws ManyObjectsForFunctionalRelationException, ServiceException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        Double gridSize = (Double)graph.getPossibleRelatedValue(diagram, dr.HasGridSize);
        return gridSize == null ? defaultValue : gridSize;
    }

    public static void setGridSize(WriteGraph graph, Resource diagram, double gridSize) throws ManyObjectsForFunctionalRelationException, ServiceException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        graph.claimLiteral(diagram, dr.HasGridSize, (Object)gridSize);
    }

    public static boolean isPageBordersVisible(ReadGraph graph, Resource diagram) throws DatabaseException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        return graph.hasStatement(diagram, dr.DisplayPageSize);
    }

    public static boolean isMarginsVisible(ReadGraph graph, Resource diagram) throws DatabaseException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        return graph.hasStatement(diagram, dr.DisplayMargins);
    }

    public static void setPageBordersVisible(WriteGraph graph, Resource diagram, boolean visible) throws DatabaseException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        DiagramGraphUtil.tag(graph, diagram, dr.DisplayPageSize, visible);
    }

    public static void setMarginsVisible(WriteGraph graph, Resource diagram, boolean visible) throws DatabaseException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        DiagramGraphUtil.tag(graph, diagram, dr.DisplayMargins, visible);
    }

    public static void setDiagramDesc(WriteGraph graph, Resource diagram, DiagramDesc desc) throws DatabaseException {
        DiagramGraphUtil.setPageDesc(graph, diagram, desc.getPageDesc());
        DiagramGraphUtil.setGridSize(graph, diagram, desc.getGridSize());
        DiagramGraphUtil.setPageBordersVisible(graph, diagram, desc.isPageBordersVisible());
        DiagramGraphUtil.setMarginsVisible(graph, diagram, desc.isMarginsVisible());
        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
        graph.addMetadata((Metadata)cm.add("Set diagram description for diagram resource " + String.valueOf(diagram)));
    }

    public static Resource getRelatedConnection(ReadGraph g, Resource element, Resource connectionRelation) throws DatabaseException {
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        for (Resource connector : g.getObjects(element, connectionRelation)) {
            for (Resource connection : g.getObjects(connector, sr.Connects)) {
                if (connection.equals(element)) continue;
                return connection;
            }
        }
        return null;
    }

    public static Resource getRelatedConnectionType(ReadGraph g, Resource element, Resource connectionRelation) throws DatabaseException {
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        for (Resource connector : g.getObjects(element, connectionRelation)) {
            for (Resource connection : g.getObjects(connector, sr.Connects)) {
                Iterator iterator;
                if (connection.equals(element) || !(iterator = g.getObjects(connection, sr.HasConnectionType).iterator()).hasNext()) continue;
                Resource connectionType = (Resource)iterator.next();
                return connectionType;
            }
        }
        return null;
    }

    public static Resource getJoinedFlag(ReadGraph g, Resource flag) throws DatabaseException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
        for (Resource join : g.getObjects(flag, dr.FlagIsJoinedBy)) {
            for (Resource otherFlag : g.getObjects(join, dr.JoinsFlag)) {
                if (otherFlag.equals(flag)) continue;
                return otherFlag;
            }
        }
        return null;
    }

    public static Resource getConnectionTypeForFlag(ReadGraph g, Resource flag) throws DatabaseException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
        Resource connectionType = DiagramGraphUtil.getRelatedConnectionType(g, flag, dr.Flag_ConnectionPoint);
        if (connectionType != null) {
            return connectionType;
        }
        Resource otherFlag = DiagramGraphUtil.getJoinedFlag(g, flag);
        if (otherFlag == null) {
            return null;
        }
        return DiagramGraphUtil.getRelatedConnectionType(g, otherFlag, dr.Flag_ConnectionPoint);
    }

    public static boolean onSameDiagram(ReadGraph graph, Resource element1, Resource element2) throws DatabaseException {
        return !Collections.disjoint(OrderedSetElementsPredicate.INSTANCE.getSubjects(graph, element1), OrderedSetElementsPredicate.INSTANCE.getSubjects(graph, element2));
    }

    public static void getPossibleRouter(AsyncReadGraph graph, Resource element, final AsyncProcedure<IRouter2> procedure) {
        DiagramResource dr = (DiagramResource)graph.getService(DiagramResource.class);
        graph.forPossibleStatement(element, dr.Routing, (AsyncProcedure)new AsyncProcedure<Statement>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }

            public void execute(AsyncReadGraph graph, Statement result) {
                if (result != null) {
                    graph.forPossibleAdapted(result.getPredicate(), IRouter2.class, procedure);
                } else {
                    procedure.execute(graph, null);
                }
            }
        });
    }

    public static void loadConnectionVisuals(ReadGraph graph, IModelingRules modelingRules, Resource connection, IDiagram diagram, IElement edge, DesignatedTerminal firstTerminal, DesignatedTerminal secondTerminal) throws DatabaseException {
        List evs = edge.getElementClass().getItemsByClass(EdgeVisuals.class);
        if (evs.isEmpty()) {
            return;
        }
        IAttachmentRelationMap attachmentRelations = modelingRules.getAttachmentRelations(graph, connection);
        IConnectionPoint firstCp = ConnectionUtil.toConnectionPoint(graph, firstTerminal);
        IConnectionPoint secondCp = ConnectionUtil.toConnectionPoint(graph, secondTerminal);
        Resource firstAttachment = null;
        Resource secondAttachment = null;
        if (firstCp instanceof CPTerminal) {
            firstAttachment = attachmentRelations.get(graph, (CPTerminal)firstCp);
        }
        if (secondCp instanceof CPTerminal) {
            secondAttachment = attachmentRelations.get(graph, (CPTerminal)secondCp);
        }
        if (DebugPolicy.DEBUG_CONNECTION_VISUALS_LOAD) {
            System.out.println("first attachment relation : " + NameUtils.getSafeName((ReadGraph)graph, (Resource)firstAttachment));
            System.out.println("second attachment relation : " + NameUtils.getSafeName((ReadGraph)graph, (Resource)secondAttachment));
        }
        DiagramGraphUtil.loadEdgeEnds(graph, modelingRules, connection, edge, firstAttachment, secondAttachment);
        DiagramGraphUtil.loadLineStyle(graph, modelingRules, connection, edge);
    }

    public static void loadEdgeEnds(ReadGraph graph, IModelingRules modelingRules, Resource connection, IElement edge, Resource firstAttachment, Resource secondAttachment) throws DatabaseException {
        EdgeVisualsConfigurer startConfig = firstAttachment != null ? (EdgeVisualsConfigurer)graph.syncRequest(Queries.adapt((Resource)firstAttachment, EdgeVisualsConfigurer.class, (boolean)true)) : null;
        EdgeVisualsConfigurer endConfig = secondAttachment != null ? (EdgeVisualsConfigurer)graph.syncRequest(Queries.adapt((Resource)secondAttachment, EdgeVisualsConfigurer.class, (boolean)true)) : null;
        for (EdgeVisuals ev : edge.getElementClass().getItemsByClass(EdgeVisuals.class)) {
            if (startConfig != null) {
                startConfig.configure(edge, ev, EdgeVisuals.BEGIN);
            } else {
                ev.setArrowType(edge, EdgeVisuals.EdgeEnd.Begin, EdgeVisuals.ArrowType.None);
            }
            if (endConfig != null) {
                endConfig.configure(edge, ev, EdgeVisuals.END);
                continue;
            }
            ev.setArrowType(edge, EdgeVisuals.EdgeEnd.End, EdgeVisuals.ArrowType.None);
        }
    }

    public static void loadLineStyle(ReadGraph graph, IModelingRules modelingRules, Resource connection, IElement edge) throws DatabaseException {
        Resource connectionType = modelingRules.getConnectionType(graph, connection);
        if (connectionType != null) {
            DiagramGraphUtil.loadLineStyleFromConnectionType(graph, modelingRules, connectionType, edge);
        }
    }

    public static void loadLineStyleFromConnectionType(ReadGraph graph, IModelingRules modelingRules, Resource connectionType, IElement edge) throws DatabaseException {
        edge.setHint(ElementHints.KEY_CONNECTION_TYPE, (Object)connectionType);
        if (DebugPolicy.DEBUG_CONNECTION_VISUALS_LOAD) {
            System.out.println("Connection type : " + NameUtils.getSafeName((ReadGraph)graph, (Resource)connectionType));
        }
        ConnectionVisuals cv = (ConnectionVisuals)graph.syncRequest(DiagramRequests.getConnectionVisuals(connectionType));
        if (cv.color != null) {
            for (FillColor fc : edge.getElementClass().getItemsByClass(FillColor.class)) {
                fc.setFillColor(edge, cv.toColor());
            }
        }
        for (EdgeVisuals ev : edge.getElementClass().getItemsByClass(EdgeVisuals.class)) {
            if (cv.stroke != null) {
                ev.setStroke(edge, cv.stroke);
            }
            if (cv.strokeType == null) continue;
            ev.setStrokeType(edge, cv.strokeType);
        }
    }

    public static ConnectionSegmentEnd resolveConnectionSegmentEnd(ReadGraph graph, Resource connectionPart) throws DatabaseException {
        BasicResources br = BasicResources.getInstance(graph);
        if (graph.isInstanceOf(connectionPart, br.DIA.BranchPoint)) {
            return ConnectionSegmentEnd.BRANCH;
        }
        if (graph.isInstanceOf(connectionPart, br.DIA.Connector)) {
            return ConnectionSegmentEnd.CONNECTOR;
        }
        return null;
    }

    public static DesignatedTerminal findDesignatedTerminal(ReadGraph graph, IDiagram diagram, Resource segmentEnd, ConnectionSegmentEnd endType) throws DatabaseException {
        if (DebugPolicy.DEBUG_TERMINAL_SEARCH) {
            System.out.println("findDesignatedTerminal: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)segmentEnd) + " : " + String.valueOf((Object)endType));
        }
        BasicResources br = BasicResources.getInstance(graph);
        DataElementMap dem = (DataElementMap)diagram.getDiagramClass().getSingleItem(DataElementMap.class);
        switch (endType) {
            case CONNECTOR: {
                ArrayList ts = new ArrayList();
                for (Statement stm : graph.getStatements(segmentEnd, br.STR.Connects)) {
                    IElement e;
                    if (graph.isSubrelationOf(stm.getPredicate(), br.DIA.IsConnectorOf)) continue;
                    Resource connectionRelation = graph.getInverse(stm.getPredicate());
                    if (DebugPolicy.DEBUG_TERMINAL_SEARCH) {
                        System.out.println("CONNECTION RELATION: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)connectionRelation));
                    }
                    Resource elementResource = stm.getObject();
                    if (DebugPolicy.DEBUG_TERMINAL_SEARCH) {
                        System.out.println("ELEMENT RESOURCE: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)elementResource));
                    }
                    if ((e = dem.getElement(diagram, (Object)elementResource)) == null) {
                        return null;
                    }
                    TerminalTopology tt = (TerminalTopology)e.getElementClass().getSingleItem(TerminalTopology.class);
                    ts.clear();
                    tt.getTerminals(e, ts);
                    for (Topology.Terminal t : ts) {
                        if (!(t instanceof ResourceTerminal)) continue;
                        ResourceTerminal rt = (ResourceTerminal)t;
                        Resource binds = DiagramGraphUtil.getConnectionPointOfTerminal(graph, rt.getResource());
                        if (DebugPolicy.DEBUG_TERMINAL_SEARCH) {
                            System.out.println("connection relation: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)connectionRelation) + " " + connectionRelation.getResourceId());
                            System.out.println("  terminal: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)rt.getResource()) + " " + rt.getResource().getResourceId());
                            System.out.println("  binds:    " + NameUtils.getSafeName((ReadGraph)graph, (Resource)binds) + " " + binds.getResourceId());
                        }
                        if (!graph.isSubrelationOf(connectionRelation, binds)) continue;
                        return new DesignatedTerminal(e, t);
                    }
                    throw new ValidationException("connector " + NameUtils.getSafeName((ReadGraph)graph, (Resource)segmentEnd) + " is connected using a relation that is not its own: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)connectionRelation));
                }
                return null;
            }
            case BRANCH: {
                ArrayList ts = new ArrayList();
                IElement e = dem.getElement(diagram, (Object)segmentEnd);
                if (e == null) {
                    return null;
                }
                TerminalTopology tt = (TerminalTopology)e.getElementClass().getSingleItem(TerminalTopology.class);
                tt.getTerminals(e, ts);
                if (ts.size() != 1) {
                    throw new IllegalStateException("branch point element has " + ts.size() + " terminals, expected 1");
                }
                return new DesignatedTerminal(e, (Topology.Terminal)ts.get(0));
            }
        }
        throw new IllegalArgumentException("unexpected connection segment end: " + String.valueOf((Object)endType));
    }

    public static DesignatedTerminal getDesignatedTerminalForConnector(ReadGraph graph, IDiagram diagram, Resource elementResource, Resource terminalRelation, Resource connector) throws DatabaseException {
        DataElementMap dem;
        IElement e;
        if (DebugPolicy.DEBUG_TERMINAL_SEARCH) {
            System.out.println("getDesignatedTerminalForConnector: (" + NameUtils.getSafeName((ReadGraph)graph, (Resource)elementResource) + ", " + NameUtils.getSafeName((ReadGraph)graph, (Resource)terminalRelation) + ", " + NameUtils.getSafeName((ReadGraph)graph, (Resource)connector) + ")");
        }
        if ((e = (dem = (DataElementMap)diagram.getDiagramClass().getSingleItem(DataElementMap.class)).getElement(diagram, (Object)elementResource)) == null) {
            return null;
        }
        TerminalTopology tt = (TerminalTopology)e.getElementClass().getSingleItem(TerminalTopology.class);
        ArrayList ts = new ArrayList();
        tt.getTerminals(e, ts);
        for (Topology.Terminal t : ts) {
            if (!(t instanceof ResourceTerminal)) continue;
            ResourceTerminal rt = (ResourceTerminal)t;
            Resource binds = DiagramGraphUtil.getConnectionPointOfTerminal(graph, rt.getResource());
            if (DebugPolicy.DEBUG_TERMINAL_SEARCH) {
                System.out.println("connection relation: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)terminalRelation, (boolean)true));
                System.out.println("  terminal: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)rt.getResource(), (boolean)true));
                System.out.println("  binds:    " + NameUtils.getSafeName((ReadGraph)graph, (Resource)binds, (boolean)true));
            }
            if (!graph.isSubrelationOf(terminalRelation, binds)) continue;
            return new DesignatedTerminal(e, t);
        }
        throw new ValidationException("terminal connection statement (" + NameUtils.getSafeName((ReadGraph)graph, (Resource)elementResource) + ", " + NameUtils.getSafeName((ReadGraph)graph, (Resource)terminalRelation) + ", " + NameUtils.getSafeName((ReadGraph)graph, (Resource)connector) + ") is using using a terminal relation that is not its own: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)terminalRelation));
    }

    public static TerminalMap getElementTerminals(ReadGraph graph, Resource element) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource elementType = graph.getPossibleType(element, DIA.Element);
        return elementType != null ? DiagramGraphUtil.getElementTypeTerminals(graph, elementType) : TerminalMap.EMPTY;
    }

    public static TerminalMap getElementTypeTerminals(ReadGraph graph, Resource elementType) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource definedBy = graph.getSingleObject(elementType, STR.IsDefinedBy);
        List parts = OrderedSetUtils.toList((ReadGraph)graph, (Resource)definedBy);
        TerminalMap result = null;
        for (Resource part : parts) {
            if (!graph.isInstanceOf(part, DIA.Terminal)) continue;
            Resource binds = DiagramGraphUtil.getConnectionPointOfTerminal(graph, part);
            if (result == null) {
                result = new TerminalMap(parts.size());
            }
            result.put(part, binds);
        }
        return result != null ? result : TerminalMap.EMPTY;
    }

    public static boolean getDiagramTagPreference(ReadGraph graph, Resource diagram, Resource preference) throws DatabaseException {
        boolean result = graph.hasStatement(diagram, preference);
        if (!result) {
            Resource model = (Resource)graph.sync((ReadInterface)new PossibleModel(diagram));
            if (model != null) {
                result = graph.hasStatement(model, preference);
            }
            if (!result) {
                result = graph.hasStatement(Simantics.getProjectResource(), preference);
            }
        }
        return result;
    }

    public static void rotateConnection(WriteGraph graph, Resource r, double cx, double cy, boolean clockwise) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        for (Resource node : graph.getObjects(r, DIA.HasInteriorRouteNode)) {
            if (!graph.isInstanceOf(node, DIA.RouteLine)) continue;
            boolean isHorizontal = (Boolean)graph.getRelatedValue(node, DIA.IsHorizontal);
            double position = (Double)graph.getRelatedValue(node, DIA.HasPosition);
            if (isHorizontal) {
                position -= cy;
                if (clockwise) {
                    position = -position;
                }
                position += cx;
            } else {
                position -= cx;
                if (!clockwise) {
                    position = -position;
                }
                position += cy;
            }
            isHorizontal = !isHorizontal;
            graph.claimLiteral(node, DIA.IsHorizontal, (Object)isHorizontal);
            graph.claimLiteral(node, DIA.HasPosition, (Object)position);
        }
    }

    public static void flipConnection(WriteGraph graph, Resource r, boolean xAxis, double c) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        for (Resource node : graph.getObjects(r, DIA.HasInteriorRouteNode)) {
            boolean isHorizontal;
            if (!graph.isInstanceOf(node, DIA.RouteLine) || (isHorizontal = ((Boolean)graph.getRelatedValue(node, DIA.IsHorizontal)).booleanValue()) != xAxis) continue;
            double position = (Double)graph.getRelatedValue(node, DIA.HasPosition);
            position = 2.0 * c - position;
            graph.claimLiteral(node, DIA.HasPosition, (Object)position);
        }
    }

    public static void addConnectionPoint(WriteGraph g, Resource symbol, Resource terminal, Resource diagramConnectionRelation) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        g.claim(terminal, DIA.HasConnectionPoint, diagramConnectionRelation);
        g.claim(diagramConnectionRelation, L0.HasDomain, symbol);
    }

    public static Resource getConnectionPointOfTerminal(ReadGraph g, Resource forTerminal) throws DatabaseException {
        return g.getSingleObject(forTerminal, DiagramResource.getInstance((ReadGraph)g).HasConnectionPoint);
    }

    public static Resource getPossibleConnectionPointOfTerminal(ReadGraph g, Resource forTerminal) throws DatabaseException {
        return g.getPossibleObject(forTerminal, DiagramResource.getInstance((ReadGraph)g).HasConnectionPoint);
    }

    public static Collection<Resource> getTerminals(ReadGraph g, Resource symbol) throws DatabaseException {
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        ArrayList<Resource> terminals = null;
        for (Resource definedBy : g.getObjects(symbol, STR.IsDefinedBy)) {
            Collection elements = g.syncRequest((AsyncMultiRead)new OrderedSet(definedBy));
            if (terminals == null) {
                terminals = new ArrayList<Resource>(elements.size());
            }
            for (Resource element : elements) {
                if (!g.isInstanceOf(element, DIA.Terminal)) continue;
                terminals.add(element);
            }
        }
        return terminals == null ? Collections.emptyList() : terminals;
    }

    public static Resource determineConnectionType(ReadGraph graph, Resource diagramConnection) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource diagram = graph.getPossibleObject(diagramConnection, L0.PartOf);
        if (diagram == null) {
            return null;
        }
        IModelingRules modelingRules = (IModelingRules)graph.syncRequest(DiagramRequests.getModelingRules(diagram, null));
        if (modelingRules == null) {
            return null;
        }
        return DiagramGraphUtil.determineConnectionType(graph, diagramConnection, modelingRules);
    }

    public static Resource determineConnectionType(ReadGraph graph, Resource diagramConnection, IModelingRules modelingRules) throws DatabaseException {
        THashSet cps = new THashSet();
        DiagramRequests.expandConnections(graph, diagramConnection, (Set<Resource>)new THashSet(), (Set<IConnectionPoint>)cps);
        return modelingRules.computeConnectionType(graph, (Collection)cps);
    }

    public static void defaultSymbolDropHandler(WriteGraph graph, List<WorkbenchSelectionElement> drop) throws DatabaseException {
        System.err.println("dropped " + String.valueOf(drop));
    }

    public static IModelingRules getModelingRules(ReadGraph graph, Resource diagram, IModelingRules defaultValue) throws DatabaseException {
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)graph);
        Resource rules = graph.getPossibleObject(diagram, sr.HasModelingRules);
        if (rules == null) {
            return defaultValue;
        }
        return (IModelingRules)graph.adapt(rules, IModelingRules.class);
    }
}

