/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.CopyHandler;
import org.simantics.db.layer0.adapter.impl.FixedRootImportAdvisor;
import org.simantics.db.layer0.util.ClipboardUtils;
import org.simantics.db.layer0.util.SimanticsClipboardBuilder;
import org.simantics.db.layer0.util.SimanticsClipboardImpl;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.diagram.internal.DebugPolicy;
import org.simantics.diagram.synchronization.CopyAdvisor;
import org.simantics.diagram.synchronization.ErrorHandler;
import org.simantics.diagram.synchronization.IModifiableSynchronizationContext;
import org.simantics.diagram.synchronization.StatementEvaluation;
import org.simantics.diagram.synchronization.SynchronizationException;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.GraphSynchronizationHints;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.hints.IHintContext;

public class CopyAdvisorUtil {
    public static final boolean DEBUG_COPY = DebugPolicy.DEBUG_COPY_PASTE;

    public static Object cut(IModifiableSynchronizationContext context, WriteGraph g, CopyAdvisor ca, Resource cut, Resource sourceContainer, Resource targetContainer) throws DatabaseException {
        if (DEBUG_COPY) {
            System.out.println("Attempting to cut component " + NameUtils.getSafeName((ReadGraph)g, (Resource)cut, (boolean)true));
        }
        try {
            context.set(GraphSynchronizationHints.READ_TRANSACTION, g);
            context.set(GraphSynchronizationHints.WRITE_TRANSACTION, g);
            Object object = ca.cut(context, cut, sourceContainer, targetContainer);
            return object;
        }
        catch (SynchronizationException e) {
            ErrorHandler eh = (ErrorHandler)context.get(SynchronizationHints.ERROR_HANDLER);
            eh.error(e.getMessage(), e);
        }
        finally {
            context.set(GraphSynchronizationHints.READ_TRANSACTION, null);
            context.set(GraphSynchronizationHints.WRITE_TRANSACTION, null);
        }
        return null;
    }

    public static Resource copy(IModifiableSynchronizationContext context, WriteGraph g, CopyAdvisor ca, Resource copyOf, Resource sourceContainer, Resource targetContainer) throws DatabaseException {
        Resource resource;
        block9: {
            resource = null;
            if (DEBUG_COPY) {
                System.out.println("Attempting to copy component " + NameUtils.getSafeName((ReadGraph)g, (Resource)copyOf, (boolean)true));
            }
            try {
                try {
                    context.set(GraphSynchronizationHints.READ_TRANSACTION, g);
                    context.set(GraphSynchronizationHints.WRITE_TRANSACTION, g);
                    CopyAdvisor.Evaluation eval = ca.canCopy(context, copyOf, sourceContainer, targetContainer);
                    if (DEBUG_COPY) {
                        System.out.println("  CopyAdvisor(" + String.valueOf(ca) + ").canCopy evaluation result: " + String.valueOf((Object)eval));
                    }
                    if (!CopyAdvisor.SUPPORTED.contains((Object)eval)) break block9;
                    Object copy = ca.copy(context, copyOf, sourceContainer, targetContainer);
                    if (DEBUG_COPY) {
                        System.out.println("  CopyAdvisor(" + String.valueOf(ca) + ").copy result: " + String.valueOf(copy));
                    }
                    if (copy instanceof Resource) {
                        resource = (Resource)copy;
                        break block9;
                    }
                    throw new UnsupportedOperationException("Cannot copy element " + String.valueOf(copyOf));
                }
                catch (SynchronizationException e) {
                    ErrorHandler eh = (ErrorHandler)context.get(SynchronizationHints.ERROR_HANDLER);
                    eh.error(e.getMessage(), e);
                    throw new DatabaseException((Throwable)e);
                }
            }
            finally {
                context.set(GraphSynchronizationHints.READ_TRANSACTION, null);
                context.set(GraphSynchronizationHints.WRITE_TRANSACTION, null);
            }
        }
        return resource;
    }

    public static Resource copy(IModifiableSynchronizationContext context, WriteGraph g, CopyAdvisor ca, Resource copyOf, Resource sourceContainer, Resource targetContainer, Map<Object, Object> map) throws DatabaseException {
        Resource resource;
        block9: {
            resource = null;
            if (DEBUG_COPY) {
                System.out.println("Attempting to copy component " + NameUtils.getSafeName((ReadGraph)g, (Resource)copyOf, (boolean)true));
            }
            try {
                try {
                    context.set(GraphSynchronizationHints.READ_TRANSACTION, g);
                    context.set(GraphSynchronizationHints.WRITE_TRANSACTION, g);
                    CopyAdvisor.Evaluation eval = ca.canCopy(context, copyOf, sourceContainer, targetContainer);
                    if (DEBUG_COPY) {
                        System.out.println("  CopyAdvisor(" + String.valueOf(ca) + ").canCopy evaluation result: " + String.valueOf((Object)eval));
                    }
                    if (!CopyAdvisor.SUPPORTED.contains((Object)eval)) break block9;
                    Object copy = ca.copy(context, copyOf, sourceContainer, targetContainer, map);
                    if (DEBUG_COPY) {
                        System.out.println("  CopyAdvisor(" + String.valueOf(ca) + ").copy result: " + String.valueOf(copy));
                        System.out.println("  CopyAdvisor(" + String.valueOf(ca) + ").copy result map: " + String.valueOf(map));
                    }
                    if (copy instanceof Resource) {
                        resource = (Resource)copy;
                        break block9;
                    }
                    throw new UnsupportedOperationException("Cannot copy element " + String.valueOf(copyOf));
                }
                catch (SynchronizationException e) {
                    ErrorHandler eh = (ErrorHandler)context.get(SynchronizationHints.ERROR_HANDLER);
                    eh.error(e.getMessage(), e);
                    throw new DatabaseException((Throwable)e);
                }
            }
            finally {
                context.set(GraphSynchronizationHints.READ_TRANSACTION, null);
                context.set(GraphSynchronizationHints.WRITE_TRANSACTION, null);
            }
        }
        return resource;
    }

    public static Resource copy(WriteGraph graph, Resource source, BiFunction<ReadGraph, Statement, Boolean> advisor) throws DatabaseException {
        return CopyAdvisorUtil.copy(graph, source, 0, advisor, (Map<Object, Object>)new THashMap());
    }

    public static Resource copy(WriteGraph graph, Resource source, BiFunction<ReadGraph, Statement, Boolean> advisor, Map<Object, Object> copyMap) throws DatabaseException {
        return CopyAdvisorUtil.copy(graph, source, 0, advisor, copyMap);
    }

    private static Resource copy(WriteGraph graph, Resource source, int level, BiFunction<ReadGraph, Statement, Boolean> advisor, Map<Object, Object> copyMap) throws DatabaseException {
        Resource copy;
        if (DEBUG_COPY) {
            System.out.println("[" + level + "] CopyAdvisorUtil.copy(" + NameUtils.getSafeName((ReadGraph)graph, (Resource)source) + ", advisor=" + String.valueOf(advisor) + ")");
        }
        if ((copy = (Resource)copyMap.get(source)) != null) {
            if (DEBUG_COPY) {
                System.out.println("[" + level + "] already copied: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)source) + " -> " + NameUtils.getSafeName((ReadGraph)graph, (Resource)copy));
            }
            return copy;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        copy = graph.newResource();
        copyMap.put(source, copy);
        for (Resource type : graph.getObjects(source, L0.InstanceOf)) {
            graph.claim(copy, L0.InstanceOf, null, type);
        }
        if (graph.hasValue(source)) {
            Datatype dt = (Datatype)graph.getRelatedValue(source, L0.HasDataType, Bindings.getBindingUnchecked(Datatype.class));
            Binding b = Bindings.getBinding((Datatype)dt);
            graph.claimValue(copy, graph.getValue(source, b), b);
        }
        for (Statement stm : graph.getStatements(source, L0.IsWeaklyRelatedTo)) {
            if (stm.isAsserted(source) || !graph.isInstanceOf(stm.getPredicate(), L0.Tag)) continue;
            if (DEBUG_COPY) {
                System.out.println("[" + level + "]\tcopying tag (" + NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getSubject()) + ", " + NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getPredicate()) + ")");
            }
            graph.claim(copy, stm.getPredicate(), stm.getPredicate(), copy);
        }
        for (Statement stm : graph.getStatements(source, L0.IsRelatedTo)) {
            Resource relation = stm.getPredicate();
            if (L0.InstanceOf.equals(relation)) continue;
            if (stm.isAsserted(source)) {
                if (!DEBUG_COPY) continue;
                System.out.println("[" + level + "]\t\tSkipping asserted statement");
                continue;
            }
            if (DEBUG_COPY) {
                System.out.println("[" + level + "]\tprocessing statement (" + NameUtils.toString((ReadGraph)graph, (Statement)stm) + ")");
            }
            Resource subject = stm.getSubject();
            Resource inverse = graph.getPossibleInverse(relation);
            boolean addInverse = false;
            Resource obj = stm.getObject();
            Resource propType = graph.getPossibleType(obj, L0.Literal);
            if (propType != null || graph.isSubrelationOf(relation, L0.IsComposedOf)) {
                if (propType != null && graph.hasStatement(propType, L0.Enumeration, propType)) {
                    if (DEBUG_COPY) {
                        System.out.println("[" + level + "]\t\tclaim enumeration statement");
                    }
                    graph.claim(copy, relation, null, obj);
                    continue;
                }
                if (inverse != null) {
                    addInverse = graph.hasStatement(obj, inverse, subject);
                }
                if (DEBUG_COPY) {
                    System.out.println("[" + level + "]\t\tcopy whole object");
                }
                Resource clone = CopyAdvisorUtil.copy(graph, obj, level + 1, advisor, copyMap);
                graph.claim(copy, relation, clone);
                continue;
            }
            if (advisor != null) {
                Boolean result = advisor.apply((ReadGraph)graph, stm);
                if (!Boolean.TRUE.equals(result)) continue;
                if (inverse != null) {
                    addInverse = graph.hasStatement(obj, inverse, subject);
                }
                if (DEBUG_COPY) {
                    System.out.println("[" + level + "]\t\tCopyAdvisorUtil.copy.claim(" + NameUtils.getSafeName((ReadGraph)graph, (Resource)copy) + ", " + NameUtils.getSafeName((ReadGraph)graph, (Resource)relation) + ", " + (addInverse ? NameUtils.getSafeName((ReadGraph)graph, (Resource)inverse) : null) + ", " + NameUtils.getSafeName((ReadGraph)graph, (Resource)obj));
                }
                graph.claim(copy, relation, (Resource)(addInverse ? inverse : null), obj);
                continue;
            }
            if (!DEBUG_COPY) continue;
            System.out.println("[" + level + "]\t\tskipping statement");
        }
        return copy;
    }

    public static Resource copy2(WriteGraph graph, Resource source, BiFunction<ReadGraph, Statement, StatementEvaluation> advisor) throws DatabaseException {
        return CopyAdvisorUtil.copy2(graph, source, advisor, (Map<Object, Object>)new THashMap());
    }

    public static Resource copy2(WriteGraph graph, Resource source, BiFunction<ReadGraph, Statement, StatementEvaluation> advisor, Map<Object, Object> copyMap) throws DatabaseException {
        THashSet pendingStatements = new THashSet();
        Resource result = CopyAdvisorUtil.copy2(graph, source, 0, advisor, copyMap, (Set<Statement4>)pendingStatements);
        CopyAdvisorUtil.postProcessStatements(graph, copyMap, (Set<Statement4>)pendingStatements);
        return result;
    }

    private static void postProcessStatements(WriteGraph graph, Map<Object, Object> copyMap, Set<Statement4> pendingStatements) throws DatabaseException {
        if (pendingStatements.isEmpty()) {
            return;
        }
        if (DEBUG_COPY) {
            System.out.println("post processing " + pendingStatements.size() + " pending statements");
        }
        for (Statement4 srcStm : pendingStatements) {
            Resource subjectCopy = (Resource)copyMap.get(srcStm.stm.getSubject());
            Resource objectCopy = (Resource)copyMap.get(srcStm.stm.getObject());
            if (subjectCopy == null || objectCopy == null) {
                if (!DEBUG_COPY) continue;
                System.out.println("skipping pending statement: " + NameUtils.toString((ReadGraph)graph, (Statement)srcStm.stm));
                continue;
            }
            if (DEBUG_COPY) {
                System.out.println("copying pending statement: " + NameUtils.toString((ReadGraph)graph, (Statement)srcStm.stm));
            }
            graph.claim(subjectCopy, srcStm.stm.getPredicate(), srcStm.inverse, objectCopy);
        }
    }

    private static Resource copy2(WriteGraph graph, Resource source, int level, BiFunction<ReadGraph, Statement, StatementEvaluation> advisor, Map<Object, Object> copyMap, Set<Statement4> pendingSourceStatements) throws DatabaseException {
        Resource copy;
        if (DEBUG_COPY) {
            System.out.println("[" + level + "] CopyAdvisorUtil.copy(" + NameUtils.getSafeName((ReadGraph)graph, (Resource)source) + ", advisor=" + String.valueOf(advisor) + ")");
        }
        if ((copy = (Resource)copyMap.get(source)) != null) {
            if (DEBUG_COPY) {
                System.out.println("[" + level + "] already copied: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)source) + " -> " + NameUtils.getSafeName((ReadGraph)graph, (Resource)copy));
            }
            return copy;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        copy = graph.newResource();
        copyMap.put(source, copy);
        for (Resource type : graph.getObjects(source, L0.InstanceOf)) {
            graph.claim(copy, L0.InstanceOf, null, type);
        }
        if (graph.hasValue(source)) {
            Datatype dt = (Datatype)graph.getRelatedValue(source, L0.HasDataType, Bindings.getBindingUnchecked(Datatype.class));
            Binding b = Bindings.getBinding((Datatype)dt);
            graph.claimValue(copy, graph.getValue(source, b), b);
        }
        for (Statement stm : graph.getStatements(source, L0.IsWeaklyRelatedTo)) {
            if (stm.isAsserted(source) || !graph.isInstanceOf(stm.getPredicate(), L0.Tag)) continue;
            if (DEBUG_COPY) {
                System.out.println("[" + level + "]\tcopying tag (" + NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getSubject()) + ", " + NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getPredicate()) + ")");
            }
            graph.claim(copy, stm.getPredicate(), stm.getPredicate(), copy);
        }
        for (Statement stm : graph.getStatements(source, L0.IsRelatedTo)) {
            Resource relation = stm.getPredicate();
            if (L0.InstanceOf.equals(relation)) continue;
            if (stm.isAsserted(source)) {
                if (!DEBUG_COPY) continue;
                System.out.println("[" + level + "]\tskipping asserted statement (" + NameUtils.toString((ReadGraph)graph, (Statement)stm) + ")");
                continue;
            }
            if (DEBUG_COPY) {
                System.out.println("[" + level + "]\tprocessing statement (" + NameUtils.toString((ReadGraph)graph, (Statement)stm) + ")");
            }
            Resource subject = stm.getSubject();
            Resource inverse = graph.getPossibleInverse(relation);
            Resource obj = stm.getObject();
            Resource propType = graph.getPossibleType(obj, L0.Literal);
            boolean addInverse = false;
            boolean forceIncludeAndFollow = false;
            switch (CopyAdvisorUtil.evaluate((ReadGraph)graph, stm, advisor)) {
                case SKIP: {
                    if (!DEBUG_COPY) break;
                    System.out.println("[" + level + "]\t\tskipping statement");
                    break;
                }
                case INCLUDE: {
                    if (inverse != null) {
                        addInverse = graph.hasStatement(obj, inverse, subject);
                    }
                    if (DEBUG_COPY) {
                        System.out.println("[" + level + "]\t\tCopyAdvisorUtil.copy2.claim(" + NameUtils.getSafeName((ReadGraph)graph, (Resource)copy) + ", " + NameUtils.getSafeName((ReadGraph)graph, (Resource)relation) + ", " + (addInverse ? NameUtils.getSafeName((ReadGraph)graph, (Resource)inverse) : null) + ", " + NameUtils.getSafeName((ReadGraph)graph, (Resource)obj));
                    }
                    graph.claim(copy, relation, (Resource)(addInverse ? inverse : null), obj);
                    break;
                }
                case INCLUDE_AND_FOLLOW: {
                    forceIncludeAndFollow = true;
                }
                case USE_DEFAULT: {
                    if (forceIncludeAndFollow || propType != null || graph.isSubrelationOf(relation, L0.IsComposedOf)) {
                        if (propType != null && graph.hasStatement(propType, L0.Enumeration, propType)) {
                            if (DEBUG_COPY) {
                                System.out.println("[" + level + "]\t\tclaim enumeration statement(" + NameUtils.getSafeName((ReadGraph)graph, (Resource)copy) + ", " + NameUtils.getSafeName((ReadGraph)graph, (Resource)relation) + ", null, " + NameUtils.getSafeName((ReadGraph)graph, (Resource)obj));
                            }
                            graph.claim(copy, relation, null, obj);
                            break;
                        }
                        if (inverse != null) {
                            addInverse = graph.hasStatement(obj, inverse, subject);
                        }
                        if (DEBUG_COPY) {
                            System.out.println("[" + level + "]\t\tcopy whole object");
                        }
                        Resource clone = CopyAdvisorUtil.copy2(graph, obj, level + 1, advisor, copyMap, pendingSourceStatements);
                        graph.claim(copy, relation, inverse, clone);
                        break;
                    }
                    if (graph.isSubrelationOf(relation, L0.IsRelatedTo)) {
                        if (DEBUG_COPY) {
                            System.out.println("[" + level + "]\t\tmarking statement as pending for post-processing");
                        }
                        pendingSourceStatements.add(new Statement4(stm, inverse));
                        break;
                    }
                    if (!DEBUG_COPY) break;
                    System.out.println("[" + level + "]\t\tskipping weak statement");
                }
            }
        }
        return copy;
    }

    public static Resource copy3(WriteGraph graph, Resource source, Resource model, BiFunction<ReadGraph, Statement, StatementEvaluation> advisor) throws DatabaseException {
        String modelURI = graph.getURI(model);
        return CopyAdvisorUtil.copy3(graph, modelURI, source, 0, advisor, (Map<Object, Object>)new THashMap());
    }

    public static Resource copy3(WriteGraph graph, Resource source, Resource model, BiFunction<ReadGraph, Statement, StatementEvaluation> advisor, Map<Object, Object> copyMap) throws DatabaseException {
        String modelURI = graph.getURI(model);
        return CopyAdvisorUtil.copy3(graph, modelURI, source, 0, advisor, copyMap);
    }

    private static Resource copy3(WriteGraph graph, String modelURI, Resource source, int level, BiFunction<ReadGraph, Statement, StatementEvaluation> advisor, Map<Object, Object> copyMap) throws DatabaseException {
        Resource copy;
        if (DEBUG_COPY) {
            System.out.println("[" + level + "] CopyAdvisorUtil.copy(" + NameUtils.getSafeName((ReadGraph)graph, (Resource)source) + ", advisor=" + String.valueOf(advisor) + ")");
        }
        if ((copy = (Resource)copyMap.get(source)) != null) {
            if (DEBUG_COPY) {
                System.out.println("[" + level + "] already copied: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)source) + " -> " + NameUtils.getSafeName((ReadGraph)graph, (Resource)copy));
            }
            return copy;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        copy = graph.newResource();
        copyMap.put(source, copy);
        for (Resource type : graph.getObjects(source, L0.InstanceOf)) {
            graph.claim(copy, L0.InstanceOf, null, type);
        }
        if (graph.hasValue(source)) {
            Datatype dt = (Datatype)graph.getRelatedValue(source, L0.HasDataType, Bindings.getBindingUnchecked(Datatype.class));
            Binding b = Bindings.getBinding((Datatype)dt);
            graph.claimValue(copy, graph.getValue(source, b), b);
        }
        for (Statement stm : graph.getStatements(source, L0.IsWeaklyRelatedTo)) {
            if (stm.isAsserted(source) || !graph.isInstanceOf(stm.getPredicate(), L0.Tag)) continue;
            if (DEBUG_COPY) {
                System.out.println("[" + level + "]\tcopying tag (" + NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getSubject()) + ", " + NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getPredicate()) + ")");
            }
            graph.claim(copy, stm.getPredicate(), stm.getPredicate(), copy);
        }
        for (Statement stm : graph.getStatements(source, L0.IsRelatedTo)) {
            Resource relation = stm.getPredicate();
            if (L0.InstanceOf.equals(relation)) continue;
            if (stm.isAsserted(source)) {
                if (!DEBUG_COPY) continue;
                System.out.println("[" + level + "]\tskipping asserted statement (" + NameUtils.toString((ReadGraph)graph, (Statement)stm) + ")");
                continue;
            }
            if (DEBUG_COPY) {
                System.out.println("[" + level + "]\tprocessing statement (" + NameUtils.toString((ReadGraph)graph, (Statement)stm) + ")");
            }
            Resource subject = stm.getSubject();
            Resource inverse = graph.getPossibleInverse(relation);
            Resource obj = stm.getObject();
            Resource propType = graph.getPossibleType(obj, L0.Literal);
            boolean addInverse = false;
            boolean forceIncludeAndFollow = false;
            switch (CopyAdvisorUtil.evaluate((ReadGraph)graph, stm, advisor)) {
                case SKIP: {
                    if (!DEBUG_COPY) break;
                    System.out.println("[" + level + "]\t\tskipping statement");
                    break;
                }
                case INCLUDE: {
                    if (inverse != null) {
                        addInverse = graph.hasStatement(obj, inverse, subject);
                    }
                    if (DEBUG_COPY) {
                        System.out.println("[" + level + "]\t\tCopyAdvisorUtil.copy2.claim(" + NameUtils.getSafeName((ReadGraph)graph, (Resource)copy) + ", " + NameUtils.getSafeName((ReadGraph)graph, (Resource)relation) + ", " + (addInverse ? NameUtils.getSafeName((ReadGraph)graph, (Resource)inverse) : null) + ", " + NameUtils.getSafeName((ReadGraph)graph, (Resource)obj));
                    }
                    graph.claim(copy, relation, (Resource)(addInverse ? inverse : null), obj);
                    break;
                }
                case INCLUDE_AND_FOLLOW: {
                    forceIncludeAndFollow = true;
                }
                case USE_DEFAULT: {
                    if (forceIncludeAndFollow || propType != null || graph.isSubrelationOf(relation, L0.IsComposedOf)) {
                        String objectURI;
                        if (propType != null && graph.hasStatement(propType, L0.Enumeration, propType)) {
                            if (DEBUG_COPY) {
                                System.out.println("[" + level + "]\t\tclaim enumeration statement(" + NameUtils.getSafeName((ReadGraph)graph, (Resource)copy) + ", " + NameUtils.getSafeName((ReadGraph)graph, (Resource)relation) + ", null, " + NameUtils.getSafeName((ReadGraph)graph, (Resource)obj));
                            }
                            graph.claim(copy, relation, null, obj);
                            break;
                        }
                        if (inverse != null) {
                            addInverse = graph.hasStatement(obj, inverse, subject);
                        }
                        if ((objectURI = graph.getPossibleURI(obj)) != null && !objectURI.startsWith(modelURI)) {
                            if (DEBUG_COPY) {
                                System.out.println("[" + level + "]\t\tclaim ontological reference");
                            }
                            graph.claim(copy, relation, null, obj);
                            break;
                        }
                        if (DEBUG_COPY) {
                            System.out.println("[" + level + "]\t\tcopy whole object");
                        }
                        Resource clone = CopyAdvisorUtil.copy3(graph, modelURI, obj, level + 1, advisor, copyMap);
                        graph.claim(copy, relation, inverse, clone);
                        break;
                    }
                    if (!DEBUG_COPY) break;
                    System.out.println("[" + level + "]\t\tskipping statement");
                }
            }
        }
        return copy;
    }

    protected static StatementEvaluation evaluate(ReadGraph graph, Statement stm, BiFunction<ReadGraph, Statement, StatementEvaluation> tester) {
        if (tester == null) {
            return StatementEvaluation.USE_DEFAULT;
        }
        return tester.apply(graph, stm);
    }

    public static Resource copy4(WriteGraph graph, Resource source) throws DatabaseException {
        CopyHandler handler = (CopyHandler)graph.adapt(source, CopyHandler.class);
        return CopyAdvisorUtil.copy4(graph, source, handler);
    }

    public static Resource copy4(WriteGraph graph, Resource source, CopyHandler copyHandler) throws DatabaseException {
        SimanticsClipboardImpl builder = new SimanticsClipboardImpl();
        copyHandler.copyToClipboard((ReadGraph)graph, (SimanticsClipboardBuilder)builder, (IProgressMonitor)new NullProgressMonitor());
        for (Set object : builder.getContents()) {
            TransferableGraph1 tg = (TransferableGraph1)ClipboardUtils.accept((ReadGraph)graph, (Set)object, (IHintContext.Key)SimanticsKeys.KEY_TRANSFERABLE_GRAPH);
            if (tg == null) continue;
            FixedRootImportAdvisor advisor = new FixedRootImportAdvisor();
            TransferableGraphs.importGraph1((WriteGraph)graph, (TransferableGraph1)tg, (IImportAdvisor)advisor);
            return advisor.getRoot();
        }
        String uri = graph.getPossibleURI(source);
        throw new DatabaseException("Failed to copy resource " + NameUtils.getSafeName((ReadGraph)graph, (Resource)source, (boolean)true) + (String)(uri != null ? " with URI " + uri : ""));
    }

    private static class Statement4 {
        public final Statement stm;
        public final Resource inverse;

        public Statement4(Statement stm, Resource inverse) {
            this.stm = stm;
            this.inverse = inverse;
        }
    }
}

