/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import java.awt.geom.AffineTransform;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.synchronization.ModificationAdapter;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramMutator;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.elementclass.BranchPoint;

public class AddBranchpoint
extends ModificationAdapter {
    IDiagram diagram;
    IElement connection;
    IElement element;

    public AddBranchpoint(IDiagram diagram, IElement connection, IElement element) {
        super(ADD_BRANCH_PRIORITY);
        this.diagram = diagram;
        this.connection = connection;
        this.element = element;
    }

    @Override
    public void perform(WriteGraph g) throws DatabaseException {
        ConnectionUtil cu = new ConnectionUtil(g);
        DiagramMutator mutator = (DiagramMutator)this.diagram.getHint(DiagramHints.KEY_MUTATOR);
        Resource connectionResource = (Resource)mutator.backendObject(this.connection);
        AffineTransform tr = ElementUtils.getTransform((IElement)this.element);
        BranchPoint.Direction dir = ((BranchPoint)this.element.getElementClass().getSingleItem(BranchPoint.class)).getDirectionPreference(this.element, null);
        Resource bp = cu.newBranchPoint(connectionResource, tr, dir);
        this.element.setHint(ElementHints.KEY_OBJECT, (Object)bp);
        mutator.register(this.element, (Object)bp);
    }
}

