/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization;

import java.util.Collection;
import org.simantics.db.WriteGraph;
import org.simantics.diagram.synchronization.IModification;
import org.simantics.diagram.synchronization.ModificationAdapter;

public class CompositeModification
extends ModificationAdapter {
    private final Collection<IModification> modifications;

    public CompositeModification(Double priority, Collection<IModification> modifications) {
        super(priority);
        this.modifications = modifications;
    }

    @Override
    public void perform(WriteGraph g) throws Exception {
        for (IModification m : this.modifications) {
            m.perform(g);
            m.markComplete();
        }
    }

    @Override
    public void completed() {
        for (IModification m : this.modifications) {
            m.completed();
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append('(');
        sb.append(this.modifications.size());
        sb.append(')');
        sb.append(this.modifications);
        return sb.toString();
    }
}

