/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.symbollibrary.ui;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.simantics.Simantics;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.diagram.symbolcontribution.EmptySymbolProviderFactory;
import org.simantics.diagram.symbolcontribution.SymbolProviderFactory;
import org.simantics.diagram.symbollibrary.ui.SymbolLibraryPage;
import org.simantics.utils.datastructures.BijectionMap;

public class SymbolPageView
extends PageBookView {
    private static final String SYMBOL_VIEW_CONTEXT = "org.simantics.diagram.symbolLibrary";
    private ISessionContextProvider contextProvider;
    private IMemento memento;
    BijectionMap<SymbolProviderFactory, IPage> providerPageMap = new BijectionMap();

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IContextService cs = (IContextService)this.getSite().getService(IContextService.class);
        cs.activateContext(SYMBOL_VIEW_CONTEXT);
    }

    protected Object getViewAdapter(Class adapter) {
        if (adapter == IContributedContentsView.class) {
            return new IContributedContentsView(){

                public IWorkbenchPart getContributingPart() {
                    return SymbolPageView.this.getContributingEditor();
                }
            };
        }
        if (adapter == ISessionContextProvider.class) {
            return this.contextProvider;
        }
        return super.getViewAdapter(adapter);
    }

    private IWorkbenchPart getContributingEditor() {
        return this.getCurrentContributingPart();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.memento = memento;
        this.init(site);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        site.setSelectionProvider(null);
        this.contextProvider = Simantics.getSessionContextProvider();
    }

    public void saveState(IMemento memento) {
        if (this.memento != null) {
            memento.putMemento(this.memento);
        }
    }

    public void dispose() {
        super.dispose();
        this.contextProvider = null;
    }

    protected IPage createDefaultPage(PageBook book) {
        SymbolLibraryPage page = new SymbolLibraryPage(EmptySymbolProviderFactory.INSTANCE);
        this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)this.getPageBook());
        return page;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        SymbolProviderFactory providerFactory = (SymbolProviderFactory)part.getAdapter(SymbolProviderFactory.class);
        if (providerFactory == null) {
            return null;
        }
        Object page = (IPage)this.providerPageMap.getRight((Object)providerFactory);
        if (page == null) {
            SymbolLibraryPage newPage = new SymbolLibraryPage(providerFactory);
            this.initPage((IPageBookViewPage)newPage);
            newPage.createControl((Composite)this.getPageBook());
            this.providerPageMap.map((Object)providerFactory, (Object)newPage);
            page = newPage;
        }
        return new PageBookView.PageRec(part, page);
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        IPage page = pageRecord.page;
        SymbolProviderFactory cfr_ignored_0 = (SymbolProviderFactory)this.providerPageMap.removeWithRight((Object)page);
        page.dispose();
        pageRecord.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null) {
            IEditorPart editor = page.getActiveEditor();
            if (editor != null) {
                return editor;
            }
            return page.getActivePart();
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof IEditorPart;
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        this.partActivated(part);
    }
}

