/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.symbollibrary.ui;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.simantics.diagram.symbolcontribution.SymbolProviderFactory;
import org.simantics.diagram.symbollibrary.ISymbolGroup;
import org.simantics.diagram.symbollibrary.ui.SymbolLibraryComposite;
import org.simantics.diagram.symbollibrary.ui.SymbolLibraryEventHandler;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.gallery.GalleryViewer;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.utils.ui.jface.BaseSelectionProvider;

public class SymbolLibraryPage
extends Page
implements IAdaptable {
    public static final String DEFAULT_CONTEXT_MENU_ID = "#SymbolLibrary";
    SymbolProviderFactory symbolProviderFactory;
    SymbolLibraryComposite library;
    Display display;
    String contextMenuId = "#SymbolLibrary";
    MenuManager menuManager;
    Menu menu;
    BaseSelectionProvider selectionProvider = new BaseSelectionProvider();
    IEventHandler internalEventAdapter = new IEventHandler(){

        public int getEventMask() {
            return EventTypes.MouseButtonMask;
        }

        public boolean handleEvent(Event e) {
            SymbolLibraryEventHandler h = SymbolLibraryPage.this.externalEventHandler;
            if (h == null) {
                return false;
            }
            if (e.context instanceof ICanvasContext) {
                Object input;
                ICanvasContext ctx = (ICanvasContext)e.context;
                GalleryViewer viewer = (GalleryViewer)ctx.getHintStack().getHint(GalleryViewer.KEY_VIEWER);
                ISymbolGroup group = null;
                if (viewer != null && (input = viewer.getInput()) instanceof ISymbolGroup) {
                    group = (ISymbolGroup)input;
                }
                h.handleEvent(e, group, viewer);
            } else if (e.context instanceof Control) {
                Control control = (Control)e.context;
                ISymbolGroup group = (ISymbolGroup)control.getData("group");
                h.handleEvent(e, group, null);
            } else {
                h.handleEvent(e, null, null);
            }
            return false;
        }
    };
    volatile SymbolLibraryEventHandler externalEventHandler = new SymbolLibraryEventHandler(){

        @Override
        public boolean handleEvent(Event event, final ISymbolGroup group, final GalleryViewer viewer) {
            if (event instanceof MouseEvent.MouseButtonReleasedEvent) {
                final MouseEvent.MouseButtonEvent be = (MouseEvent.MouseButtonEvent)event;
                if (be.button != 2) {
                    return false;
                }
                AWTThread.getThreadAccess().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        StructuredSelection _selection = StructuredSelection.EMPTY;
                        if (viewer != null) {
                            _selection = viewer.getSelection();
                        }
                        if (_selection.isEmpty() && group != null) {
                            _selection = new StructuredSelection((Object)group);
                        }
                        StructuredSelection selection = _selection;
                        SWTUtils.asyncExec((Display)(this).SymbolLibraryPage.this.display, (Runnable)new Runnable((ISelection)selection, be){
                            private final /* synthetic */ ISelection val$selection;
                            private final /* synthetic */ MouseEvent.MouseButtonEvent val$be;
                            {
                                this.val$selection = iSelection;
                                this.val$be = mouseButtonEvent;
                            }

                            @Override
                            public void run() {
                                if (((this).this).SymbolLibraryPage.this.library.isDisposed()) {
                                    return;
                                }
                                ((this).this).SymbolLibraryPage.this.selectionProvider.setAndFireNonEqualSelection(this.val$selection);
                                ((this).this).SymbolLibraryPage.this.menu.setLocation((int)this.val$be.screenPosition.getX(), (int)this.val$be.screenPosition.getY());
                                ((this).this).SymbolLibraryPage.this.menu.setVisible(true);
                            }
                        });
                    }
                });
            }
            return false;
        }
    };

    public SymbolLibraryPage(SymbolProviderFactory symbolProviderFactory) {
        this.symbolProviderFactory = symbolProviderFactory;
    }

    public SymbolLibraryEventHandler setEventHandler(SymbolLibraryEventHandler handler) {
        SymbolLibraryEventHandler old = this.externalEventHandler;
        this.externalEventHandler = handler;
        return old;
    }

    public SymbolLibraryEventHandler getEventHandler() {
        return this.externalEventHandler;
    }

    public void createControl(Composite parent) {
        this.display = parent.getDisplay();
        this.library = new SymbolLibraryComposite(parent, 0, this.symbolProviderFactory);
        this.library.setEventHandler(this.internalEventAdapter);
        this.library.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SymbolLibraryPage.this.library = null;
            }
        });
        IPageSite site = this.getSite();
        if (site != null && this.contextMenuId != null) {
            this.menuManager = new MenuManager("Symbol Library", this.contextMenuId);
            this.menuManager.setRemoveAllWhenShown(true);
            this.menuManager.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    SymbolLibraryPage.this.menuManager.add((IContributionItem)new GroupMarker("wbStart"));
                }
            });
            this.menu = this.menuManager.createContextMenu((Control)this.library);
            this.library.setMenu(this.menu);
            site.registerContextMenu(this.menuManager.getId(), this.menuManager, (ISelectionProvider)this.selectionProvider);
        }
    }

    public Control getControl() {
        return this.library;
    }

    public void setAllExpandedStates(boolean value) {
        this.library.setAllExpandedStates(value);
    }

    public void setFocus() {
        if (this.library != null && !this.library.isDisposed()) {
            this.library.setFocus();
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == ISelectionProvider.class) {
            return (T)this.selectionProvider;
        }
        if (adapter == ISelection.class) {
            return (T)this.selectionProvider.getSelection();
        }
        return null;
    }
}

