/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.symbollibrary.ui;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.diagram.symbollibrary.ui.FilterConfiguration;
import org.simantics.diagram.symbollibrary.ui.GroupFilter;
import org.simantics.utils.ui.ISelectionUtils;

public class FilterDialog
extends TrayDialog {
    private static final String FILTER_DIALOG = "FilterDialog";
    private IDialogSettings dialogSettings;
    private Label filterTextLabel;
    private Text filterText;
    private CheckboxTableViewer filterTable;
    private FilterConfiguration config;
    private GroupFilter selectedFilter;

    public FilterDialog(Shell parentShell, IDialogSettings settings, FilterConfiguration config) {
        super(parentShell);
        this.config = config;
        this.dialogSettings = settings.getSection(FILTER_DIALOG);
        if (this.dialogSettings == null) {
            this.dialogSettings = settings.addNewSection(FILTER_DIALOG);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Group Filters");
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.dialogSettings;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        Point result;
        Point defaultSize = this.getShell().computeSize(-1, -1, true);
        if (defaultSize.equals((Object)(result = super.getInitialSize()))) {
            return new Point(600, 500);
        }
        return result;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite grid = new Composite(container, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)grid);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(grid);
        Label l = new Label(grid, 0);
        l.setText("Filters:");
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)l);
        this.createFilterTable(grid);
        this.createFilterButtons(grid);
        this.createFilterConfigurationArea(grid);
        this.filterTable.setSelection((ISelection)StructuredSelection.EMPTY);
        this.initializeFilterTable();
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private void initializeFilterTable() {
        if (!this.config.getFilters().isEmpty()) {
            this.filterTable.setSelection((ISelection)new StructuredSelection((Object)this.config.getFilters().iterator().next()));
        }
    }

    private void setFilterConfigurationEnabled(GroupFilter filter) {
        boolean enabled = filter != null;
        this.filterTextLabel.setEnabled(enabled);
        this.filterText.setEnabled(enabled);
        if (enabled) {
            this.filterText.setText(filter.getFilterText());
        } else {
            this.filterText.setText("");
        }
    }

    private void createFilterTable(Composite parent) {
        Composite base = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)base);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(base);
        this.filterTable = CheckboxTableViewer.newCheckList((Composite)base, (int)2050);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.filterTable.getControl());
        final TableViewerColumn column = new TableViewerColumn((TableViewer)this.filterTable, 16384);
        final TextCellEditor editor = new TextCellEditor((Composite)this.filterTable.getTable());
        TableViewerEditor.create((TableViewer)this.filterTable, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this.filterTable){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                boolean isLeftMouseSelect;
                boolean singleSelect = ((IStructuredSelection)FilterDialog.this.filterTable.getSelection()).size() == 1;
                boolean bl = isLeftMouseSelect = event.eventType == 3 && ((MouseEvent)event.sourceEvent).button == 1;
                return singleSelect && (isLeftMouseSelect || event.eventType == 4 || event.eventType == 5);
            }
        }, (int)1);
        column.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                GroupFilter f = (GroupFilter)cell.getElement();
                cell.setText(f.getName());
            }
        });
        column.setEditingSupport(new EditingSupport((ColumnViewer)this.filterTable){

            protected void setValue(Object element, Object value) {
                GroupFilter f = (GroupFilter)element;
                f.setName((String)value);
                Collections.sort(FilterDialog.this.config.getFilters());
                FilterDialog.this.filterTable.refresh();
            }

            protected Object getValue(Object element) {
                GroupFilter f = (GroupFilter)element;
                return f.getName();
            }

            protected CellEditor getCellEditor(Object element) {
                return editor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        this.filterTable.setUseHashlookup(true);
        this.filterTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.filterTable.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider());
        this.filterTable.setInput(this.config.getFilters());
        this.filterTable.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                GroupFilter gf = (GroupFilter)event.getElement();
                gf.setActive(event.getChecked());
            }
        });
        this.filterTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ss = (IStructuredSelection)event.getSelection();
                FilterDialog.this.selectedFilter = (GroupFilter)ISelectionUtils.filterSingleSelection((Object)ss, GroupFilter.class);
                FilterDialog.this.setFilterConfigurationEnabled(FilterDialog.this.selectedFilter);
            }
        });
        this.filterTable.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point size = FilterDialog.this.filterTable.getTable().getSize();
                column.getColumn().setWidth(size.x - FilterDialog.this.filterTable.getTable().getBorderWidth() * 2);
            }
        });
        for (GroupFilter gf : this.config.getFilters()) {
            if (!gf.isActive()) continue;
            this.filterTable.setChecked((Object)gf, true);
        }
        Button and = new Button(base, 16);
        and.setText("Match all filters");
        and.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FilterDialog.this.setMode(FilterConfiguration.Mode.AND);
            }
        });
        Button or = new Button(base, 16);
        or.setText("Match any filter");
        or.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FilterDialog.this.setMode(FilterConfiguration.Mode.OR);
            }
        });
        switch (this.config.getMode()) {
            case AND: {
                and.setSelection(true);
                break;
            }
            case OR: {
                or.setSelection(true);
            }
        }
    }

    protected void setMode(FilterConfiguration.Mode mode) {
        this.config.setMode(mode);
    }

    private void createFilterButtons(Composite grid) {
        Composite buttons = new Composite(grid, 0);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)buttons);
        RowLayout rl = new RowLayout(512);
        rl.fill = true;
        rl.marginBottom = 0;
        rl.marginLeft = 0;
        rl.marginRight = 0;
        rl.marginTop = 0;
        buttons.setLayout((Layout)rl);
        Button add = new Button(buttons, 0);
        add.setText("&New...");
        add.setToolTipText("Add New Filter");
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog id = new InputDialog(FilterDialog.this.getShell(), "Add New Filter", "Select Filter Name", "", new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.trim().isEmpty()) {
                            return "Please give a non-empty name";
                        }
                        return null;
                    }
                });
                int result = id.open();
                if (result != 0) {
                    return;
                }
                FilterDialog.this.config.getFilters().add(new GroupFilter(id.getValue(), id.getValue(), false));
                Collections.sort(FilterDialog.this.config.getFilters());
                FilterDialog.this.filterTable.refresh();
            }
        });
        Button remove = new Button(buttons, 0);
        remove.setText("&Remove");
        remove.setToolTipText("Remove Selected Filter(s)");
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List selected = ISelectionUtils.filterSelection((ISelection)FilterDialog.this.filterTable.getSelection(), GroupFilter.class);
                for (GroupFilter f : selected) {
                    FilterDialog.this.config.getFilters().remove(f);
                }
                FilterDialog.this.filterTable.refresh();
            }
        });
        new Label(buttons, 0);
        Button activateAll = new Button(buttons, 0);
        activateAll.setText("&Activate All");
        activateAll.setToolTipText("Activate All Filters");
        activateAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (GroupFilter gf : FilterDialog.this.config.getFilters()) {
                    FilterDialog.this.setActive(gf, true);
                }
            }
        });
        Button deactivateAll = new Button(buttons, 0);
        deactivateAll.setText("&Deactivate All");
        deactivateAll.setToolTipText("Deactivate All Filters");
        deactivateAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (GroupFilter gf : FilterDialog.this.config.getFilters()) {
                    FilterDialog.this.setActive(gf, false);
                }
            }
        });
    }

    private void setActive(GroupFilter group, boolean active) {
        group.setActive(active);
        this.filterTable.setChecked((Object)group, active);
    }

    private void createFilterConfigurationArea(Composite grid) {
        Composite base = new Composite(grid, 0);
        GridDataFactory.fillDefaults().indent(12, 0).grab(true, true).applyTo((Control)base);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(base);
        this.filterTextLabel = new Label(base, 0);
        this.filterTextLabel.setText("Group name filter:");
        this.filterText = new Text(base, 2048);
        this.filterText.setToolTipText("Regular Expression for Filtering by Group Name");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.filterText);
        Listener l = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 24: {
                        if (FilterDialog.this.selectedFilter == null) break;
                        FilterDialog.this.selectedFilter.setFilterText(FilterDialog.this.filterText.getText());
                    }
                }
            }
        };
        this.filterText.addListener(24, l);
    }

    private static class FilterLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private FilterLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getText(Object element) {
            return ((GroupFilter)element).getName();
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((GroupFilter)element).getName();
        }
    }
}

