/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.scl;

import java.awt.Color;
import org.simantics.db.Resource;
import org.simantics.diagram.symbollibrary.ISymbolItem;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.diagram.DiagramClass;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.handler.layout.FlowLayout;
import org.simantics.g2d.diagram.impl.Diagram;
import org.simantics.g2d.diagram.participant.DiagramParticipant;
import org.simantics.g2d.diagram.participant.ElementInteractor;
import org.simantics.g2d.diagram.participant.ElementPainter;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.StaticSymbol;
import org.simantics.g2d.element.impl.Element;
import org.simantics.g2d.gallery.GalleryItemSGNode;
import org.simantics.g2d.image.DefaultImages;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.participant.BackgroundPainter;
import org.simantics.g2d.participant.KeyToCommand;
import org.simantics.g2d.participant.KeyUtil;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.g2d.participant.SymbolUtil;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.tooltip.TooltipParticipant;
import org.simantics.scenegraph.g2d.events.command.CommandKeyBinding;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.threads.CurrentThread;
import org.simantics.utils.threads.IThreadWorkQueue;

public class SymbolLibrary {
    public static ICanvasContext create(ISymbolItem item) {
        return SymbolLibrary.create(item, true);
    }

    public static ICanvasContext create(ISymbolItem item, boolean selection) {
        IDiagram diagram = Diagram.spawnNew((DiagramClass)DiagramClass.DEFAULT);
        diagram.setHint(FlowLayout.HGAP, (Object)5.0);
        diagram.setHint(FlowLayout.VGAP, (Object)5.0);
        IThreadWorkQueue thread = CurrentThread.getThreadAccess();
        CanvasContext ctx = new CanvasContext(thread);
        SymbolLibrary.initializeCanvasContext(ctx, selection);
        IHintContext hintCtx = ctx.getDefaultHintContext();
        ElementClass ec = item.getElementClass((IHintObservable)diagram);
        StaticSymbol ss = (StaticSymbol)ec.getSingleItem(StaticSymbol.class);
        Image source = ss == null ? (Image)DefaultImages.UNKNOWN2.get() : ss.getImage();
        IElement element = Element.spawnNew((ElementClass)ec);
        element.setHint(ElementHints.KEY_OBJECT, (Object)item);
        element.setHint(GalleryItemSGNode.KEY_IMAGE, (Object)source);
        diagram.addElement(element);
        hintCtx.setHint(DiagramHints.KEY_DIAGRAM, (Object)diagram);
        return ctx;
    }

    public static Resource getItemResource(ISymbolItem item) {
        return (Resource)item.getAdapter(Resource.class);
    }

    private static void initializeCanvasContext(CanvasContext canvasContext, boolean selection) {
        IHintContext h = canvasContext.getDefaultHintContext();
        canvasContext.add((Object)new TransformUtil());
        canvasContext.add((Object)new MouseUtil());
        canvasContext.add((Object)new KeyUtil());
        canvasContext.add((Object)new SymbolUtil());
        h.setHint(Hints.KEY_BACKGROUND_COLOR, (Object)Color.WHITE);
        canvasContext.add((Object)new BackgroundPainter());
        canvasContext.add((Object)new KeyToCommand(CommandKeyBinding.DEFAULT_BINDINGS));
        PointerInteractor pi = new PointerInteractor(true, true, false, true, false, null);
        pi.setBoxSelectMode(PickRequest.PickPolicy.PICK_INTERSECTING_OBJECTS);
        canvasContext.add((Object)pi);
        canvasContext.add((Object)new Selection());
        canvasContext.add((Object)new DiagramParticipant());
        canvasContext.add((Object)new ElementPainter(selection));
        canvasContext.add((Object)new ElementInteractor());
        canvasContext.add((Object)new TooltipParticipant());
        h.setHint(ElementPainter.KEY_SELECTION_FRAME_COLOR, (Object)Color.WHITE);
        h.setHint(ElementPainter.KEY_SELECTION_CONTENT_COLOR, (Object)new Color(0.7f, 0.7f, 1.0f, 0.5f));
        h.setHint(Hints.KEY_TOOL, (Object)Hints.POINTERTOOL);
        canvasContext.assertParticipantDependencies();
    }
}

