/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.simantics.NameLabelUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.binaryPredicates.OrderedSetElementsPredicate;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.utils.StructuralUtils;

public class FlagTextQuery
extends ResourceRead<String[]> {
    private static final boolean DEBUG = false;
    static final String[] NO_RESULT = new String[]{"?", "?"};

    public FlagTextQuery(Resource flag) {
        super(flag);
    }

    public String[] perform(ReadGraph g) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)g);
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
        Resource connectionJoin = g.getPossibleObject(this.resource, dr.FlagIsJoinedBy);
        if (connectionJoin == null) {
            return NO_RESULT;
        }
        Resource diagram = this.getFirstOwnerDiagram(g, this.resource);
        if (diagram == null) {
            return NO_RESULT;
        }
        String DiagramToCompositeURI = "http://www.simantics.org/Modeling-1.2/DiagramToComposite";
        Resource DiagramToComposite = g.getResource(DiagramToCompositeURI);
        Resource composite = g.getPossibleObject(diagram, DiagramToComposite);
        if (composite == null) {
            return NO_RESULT;
        }
        Collection<Resource> connectionsOnFlagDiagram = this.findConnectionOnCompositeFromJoin(g, composite, connectionJoin);
        for (Resource connection : StructuralUtils.getRelatedConnectionsOfConnectionJoin((RequestProcessor)g, (Resource)connectionJoin, connectionsOnFlagDiagram)) {
            Iterator iterator = g.getObjects(connection, sr.Connects).iterator();
            if (!iterator.hasNext()) continue;
            Resource component = (Resource)iterator.next();
            return new String[]{FlagTextQuery.getSafeLabel(g, g.getSingleObject(component, l0.PartOf)), FlagTextQuery.getSafeLabel(g, component)};
        }
        return NO_RESULT;
    }

    private Resource getFirstOwnerDiagram(ReadGraph graph, Resource diagramPart) throws DatabaseException {
        Resource diagram = null;
        Iterator iterator = OrderedSetElementsPredicate.INSTANCE.getSubjects(graph, this.resource).iterator();
        if (iterator.hasNext()) {
            Resource temp;
            diagram = temp = (Resource)iterator.next();
        }
        return diagram;
    }

    private Collection<Resource> findConnectionOnCompositeFromJoin(ReadGraph graph, Resource composite, Resource connectionJoin) throws DatabaseException {
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)graph);
        ArrayList<Resource> result = new ArrayList<Resource>(1);
        for (Resource connection : graph.getObjects(connectionJoin, sr.Joins)) {
            if (!StructuralUtils.isConnectionInComposite((ReadGraph)graph, (Resource)connection, (Resource)composite)) continue;
            result.add(connection);
        }
        return result;
    }

    public static String getSafeLabel(ReadGraph graph, Resource r) throws DatabaseException {
        return NameLabelUtil.modalName((ReadGraph)graph, (Resource)r);
    }
}

