/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.datatypes.literal.RGB;
import org.simantics.datatypes.literal.Vec2d;
import org.simantics.diagram.elements.DiagramNodeUtil;
import org.simantics.diagram.elements.SVGNode;
import org.simantics.diagram.internal.Activator;
import org.simantics.diagram.profile.ButtonMode;
import org.simantics.diagram.profile.ButtonResult;
import org.simantics.diagram.profile.IconButtonNode;
import org.simantics.diagram.profile.IconButtonResult;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.scl.runtime.function.Function1;

public class ButtonNode
extends IconButtonNode {
    private static final long serialVersionUID = -1963362069190362275L;
    private ButtonResult.B config;
    private boolean isDown = false;
    private Function1<Boolean, Boolean> pressed;
    private static SVGNode ON = new SVGNode();
    private static SVGNode OFF = new SVGNode();
    private static boolean initialized = false;
    Rectangle2D EMPTY = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private SVGNode current = OFF;
    private Rectangle2D lastBounds = this.EMPTY;

    public void staticInit() {
        if (!initialized) {
            ON.setData(this.createSVG("BUTTON_ON"));
            OFF.setData(this.createSVG("BUTTON_OFF"));
            initialized = true;
        }
    }

    public void init() {
        this.staticInit();
        this.addEventHandler((IEventHandler)this);
    }

    public void cleanup() {
        this.removeEventHandler((IEventHandler)this);
        super.cleanup();
    }

    private void setValue(double value) {
        if (ButtonMode.LATCH.equals((Object)this.config.mode)) {
            return;
        }
        this.current = value < 0.5 ? OFF : ON;
    }

    private void setConfig(ButtonResult.B config) {
        if (this.config == config) {
            return;
        }
        this.config = config;
    }

    public void setA(ButtonResult.A data) {
        this.setConfig(data.config);
        this.setValue(data.value);
    }

    public void render(Graphics2D g2d) {
        AffineTransform ot = null;
        if (!this.transform.isIdentity()) {
            ot = g2d.getTransform();
            g2d.transform(this.transform);
        }
        this.current.render(g2d);
        this.lastBounds = this.current.getBounds();
        if (ot != null) {
            g2d.setTransform(ot);
        }
    }

    public Rectangle2D getBoundsInLocal() {
        return this.lastBounds;
    }

    @Override
    void setData(IconButtonResult state) {
        ButtonResult br = (ButtonResult)state;
        this.setA(br.getA());
        this.pressed = br.getPressed();
    }

    private boolean hitTest(MouseEvent event) {
        Rectangle2D bounds = this.getBounds();
        if (bounds == null) {
            return false;
        }
        Point2D localPos = NodeUtil.worldToLocal((IG2DNode)this, (Point2D)event.controlPosition, (Point2D)new Point2D.Double());
        double x = localPos.getX();
        double y = localPos.getY();
        return bounds.contains(x, y);
    }

    protected boolean mouseButtonPressed(MouseEvent.MouseButtonPressedEvent e) {
        if (!e.hasAnyButton(1)) {
            return false;
        }
        if (!this.hitTest((MouseEvent)e)) {
            return false;
        }
        if (this.pressed != null) {
            this.pressed.apply((Object)true);
            this.isDown = true;
            if (ButtonMode.LATCH.equals((Object)this.config.mode)) {
                this.current = ON;
                DiagramNodeUtil.getCanvasContext((IG2DNode)this).getContentContext().setDirty();
            }
        }
        return true;
    }

    protected boolean mouseButtonReleased(MouseEvent.MouseButtonReleasedEvent e) {
        if (e.hasAnyButton(1)) {
            return false;
        }
        if (!this.hitTest((MouseEvent)e) && !this.isDown) {
            return false;
        }
        if (this.pressed != null) {
            this.pressed.apply((Object)false);
            this.isDown = false;
            if (ButtonMode.LATCH.equals((Object)this.config.mode)) {
                this.current = OFF;
                DiagramNodeUtil.getCanvasContext((IG2DNode)this).getContentContext().setDirty();
            }
        }
        return true;
    }

    public int getEventMask() {
        return EventTypes.MouseButtonPressedMask | EventTypes.MouseButtonReleasedMask;
    }

    public String createSVG(String iconName) {
        return (String)Activator.ICON_PROVIDER.apply((Object)iconName, (Object)new RGB.Integer(0, 0, 0), (Object)new Vec2d(1.0, 1.0));
    }
}

