/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.participant;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.simantics.g2d.diagram.participant.pointertool.TerminalUtil;
import org.simantics.g2d.elementclass.BranchPoint;

public class ControlPoint {
    private final Point2D position = new Point2D.Double();
    private BranchPoint.Direction direction;
    private TerminalUtil.TerminalInfo attachedToTerminal = null;

    public ControlPoint(Point2D pos) {
        this(pos, BranchPoint.Direction.Any);
    }

    public ControlPoint(Point2D pos, BranchPoint.Direction direction) {
        this.position.setLocation(pos);
        this.direction = direction;
    }

    public ControlPoint setPosition(Point2D position) {
        this.position.setLocation(position);
        return this;
    }

    public ControlPoint setPosition(double x, double y) {
        this.position.setLocation(x, y);
        return this;
    }

    public ControlPoint setPosition(AffineTransform at) {
        this.position.setLocation(at.getTranslateX(), at.getTranslateY());
        return this;
    }

    public ControlPoint setDirection(BranchPoint.Direction direction) {
        if (direction == null) {
            throw new NullPointerException("trying to set null direction");
        }
        this.direction = direction;
        return this;
    }

    public ControlPoint setAttachedToTerminal(TerminalUtil.TerminalInfo info) {
        this.attachedToTerminal = info;
        return this;
    }

    public BranchPoint.Direction getDirection() {
        return this.direction;
    }

    public Point2D getPosition() {
        return new Point2D.Double(this.position.getX(), this.position.getY());
    }

    public boolean isAttachedToTerminal() {
        return this.attachedToTerminal != null;
    }

    public TerminalUtil.TerminalInfo getAttachedTerminal() {
        return this.attachedToTerminal;
    }

    public String toString() {
        return "[" + String.valueOf(this.position) + ", " + String.valueOf(this.direction) + ", " + this.isAttachedToTerminal() + "]";
    }
}

