/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.participant;

import java.util.Collection;
import java.util.Collections;

public class ContextState {
    private Collection<String> contexts;
    private boolean contextsSet;

    public ContextState() {
        this.contexts = Collections.emptyList();
        this.contextsSet = false;
    }

    public ContextState(String context) {
        this.contexts = Collections.singleton(context);
        this.contextsSet = true;
    }

    public ContextState(Collection<String> contexts) {
        this.setContexts(contexts);
    }

    void setContexts(Collection<String> contexts) {
        if (this.contextsSet) {
            throw new IllegalStateException("contexts can only be set once");
        }
        this.contexts = Collections.unmodifiableCollection(contexts);
        this.contextsSet = true;
    }

    Collection<String> getContexts() {
        return this.contexts;
    }

    boolean contextsAreSet() {
        return this.contextsSet;
    }

    public String toString() {
        return "ContextState : " + this.getContexts().toString();
    }
}

