/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.flag;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.PossibleObject;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.diagram.flag.FlagLabelingScheme;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.utils.ui.ErrorLogger;

public class DiagramFlagPreferences {
    public static Resource getActiveFlagLabelingSchemeResource(RequestProcessor processor) throws DatabaseException {
        Resource project = Simantics.getProjectResource();
        if (project == null) {
            throw new IllegalStateException("no project is active");
        }
        return (Resource)processor.syncRequest((Read)new ReadFlagLabelingSchemeResource(project));
    }

    public static FlagLabelingScheme getActiveFlagLabelingScheme(RequestProcessor processor) throws DatabaseException {
        Resource project = Simantics.getProjectResource();
        if (project == null) {
            throw new IllegalStateException("no project is active");
        }
        return (FlagLabelingScheme)processor.syncRequest((Read)new ReadFlagLabelingScheme(project));
    }

    public static void setProjectFlagLabelingScheme(Resource scheme) {
        Resource project = Simantics.getProjectResource();
        if (project == null) {
            throw new IllegalStateException("no project is active");
        }
        DiagramFlagPreferences.setFlagLabelingScheme(Simantics.getSession(), project, scheme);
    }

    public static void setFlagLabelingScheme(Session session, final Resource forTarget, final Resource scheme) {
        session.asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                DiagramFlagPreferences.setFlagLabelingScheme(graph, forTarget, scheme);
            }
        }, parameter -> {
            if (parameter != null) {
                ErrorLogger.defaultLogError((Throwable)parameter);
            }
        });
    }

    public static void setFlagLabelingScheme(WriteGraph graph, Resource forTarget, Resource scheme) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        graph.deny(forTarget, DIA.UsesLocalFlagLabelingScheme);
        graph.claim(forTarget, DIA.UsesLocalFlagLabelingScheme, scheme);
    }

    public static class ReadFlagLabelingScheme
    extends ResourceRead<FlagLabelingScheme> {
        public ReadFlagLabelingScheme(Resource resource) {
            super(resource);
        }

        public FlagLabelingScheme perform(ReadGraph graph) throws DatabaseException {
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            Resource scheme = (Resource)graph.syncRequest((Read)new ReadFlagLabelingSchemeResource(this.resource));
            if (scheme == null) {
                return (FlagLabelingScheme)graph.adapt(DIA.FlagLabelingScheme_Alphabetical, FlagLabelingScheme.class);
            }
            return (FlagLabelingScheme)graph.adapt(scheme, FlagLabelingScheme.class);
        }
    }

    public static class ReadFlagLabelingSchemeResource
    extends ResourceRead<Resource> {
        public ReadFlagLabelingSchemeResource(Resource resource) {
            super(resource);
        }

        public Resource perform(ReadGraph graph) throws DatabaseException {
            DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
            Resource scheme = (Resource)graph.syncRequest((AsyncRead)new PossibleObject(this.resource, DIA.UsesLocalFlagLabelingScheme));
            return scheme;
        }
    }
}

