/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.export;

import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.diagram.elements.DiagramNodeUtil;
import org.simantics.diagram.export.ImageBuilder;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.chassis.ICanvasChassis;
import org.simantics.g2d.chassis.SWTChassis;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.scenegraph.ICanvasSceneGraphProvider;
import org.simantics.g2d.scenegraph.SceneGraphConstants;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.nodes.NavigationNode;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.structural2.StructuralVariables;
import org.simantics.utils.DataContainer;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.threads.WorkerThread;

public class ImagePrinter {
    public static BufferedImage printToImage(IProgressMonitor monitor, ImageExportPlan exportPlan) throws Exception {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Export to Image", (int)1);
        WorkerThread workerThread = new WorkerThread("Diagram Image Painter");
        workerThread.start();
        String loc = exportPlan.exportLocation == null ? "clipboard" : exportPlan.exportLocation.getAbsolutePath();
        progress.beginTask("Writing " + exportPlan.name + " to " + loc, 1);
        return ImagePrinter.render((IThreadWorkQueue)workerThread, Simantics.getSessionContext(), exportPlan);
    }

    public static BufferedImage render(final IThreadWorkQueue thread, final ISessionContext sessionContext, final ImageExportPlan exportPlan) throws Exception {
        final DataContainer result = new DataContainer(null);
        final DataContainer exception = new DataContainer();
        final CanvasContext ctx = new CanvasContext(thread);
        final AtomicReference sgProvider = new AtomicReference();
        try {
            final Semaphore done = new Semaphore(0);
            ThreadUtils.getBlockingWorkExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        try {
                            Pair modelAndRVI = (Pair)sessionContext.getSession().syncRequest((Read)new UniqueRead<Pair<Resource, String>>(){

                                public Pair<Resource, String> perform(ReadGraph graph) throws DatabaseException {
                                    return new Pair((Object)ImagePrinter.resolveModel(graph, exportPlan.diagram), (Object)ImagePrinter.resolveRVI(graph, exportPlan.diagram));
                                }
                            });
                            ICanvasSceneGraphProvider provider = DiagramNodeUtil.loadSceneGraphProvider((ICanvasContext)ctx, (Resource)modelAndRVI.first, exportPlan.diagram, (String)modelAndRVI.second);
                            sgProvider.set(provider);
                            ThreadUtils.asyncExec((IThreadWorkQueue)thread, (Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        try {
                                            ImageBuilder chassis = new ImageBuilder(exportPlan.exportLocation, exportPlan.dpi, exportPlan.size, exportPlan.margin);
                                            result.set((Object)chassis.paint((ICanvasContext)ctx));
                                        }
                                        catch (Exception e) {
                                            exception.set((Object)e);
                                            done.release();
                                        }
                                    }
                                    finally {
                                        done.release();
                                    }
                                }
                            });
                        }
                        catch (DatabaseException e) {
                            done.release();
                            exception.set((Object)e);
                            done.release();
                        }
                        catch (Throwable e) {
                            done.release();
                            exception.set((Object)new DatabaseException(e));
                            done.release();
                        }
                    }
                    finally {
                        done.release();
                    }
                }
            });
            done.acquire(2);
            if (exception.get() != null) {
                throw (Exception)exception.get();
            }
            BufferedImage bufferedImage = (BufferedImage)result.get();
            return bufferedImage;
        }
        finally {
            if (sgProvider.get() != null) {
                ((ICanvasSceneGraphProvider)sgProvider.get()).dispose();
            }
            ctx.dispose();
        }
    }

    public static BufferedImage renderLocal(final ICanvasContext context, final ICanvasChassis chassis, final ImageExportPlan exportPlan) throws Exception {
        final Semaphore done = new Semaphore(0);
        final DataContainer result = new DataContainer(null);
        final DataContainer exception = new DataContainer(null);
        ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        result.set((Object)ImagePrinter.renderLocal(context, exportPlan, chassis));
                    }
                    catch (Exception e) {
                        exception.set((Object)e);
                        done.release();
                    }
                }
                finally {
                    done.release();
                }
            }
        });
        done.acquire();
        if (exception.get() != null) {
            throw (Exception)exception.get();
        }
        return (BufferedImage)result.get();
    }

    private static BufferedImage renderLocal(ICanvasContext context, ImageExportPlan exportPlan, ICanvasChassis chassis) throws Exception {
        TransformUtil util = (TransformUtil)context.getSingleItem(TransformUtil.class);
        AffineTransform at = util.getTransform();
        final NavigationNode node = (NavigationNode)NodeUtil.findNodeById((INode)context.getSceneGraph(), (String[])SceneGraphConstants.NAVIGATION_NODE_PATH);
        boolean adapt = true;
        if (node != null) {
            adapt = node.getAdaptViewportToResizedControl();
            node.setAdaptViewportToResizedControl(Boolean.valueOf(false));
        }
        ImageBuilder builder = new ImageBuilder(exportPlan.exportLocation, exportPlan.dpi, exportPlan.size, exportPlan.margin);
        BufferedImage image = builder.paint(context);
        util.setTransform(at);
        if (node != null && adapt) {
            if (chassis instanceof SWTChassis) {
                ((SWTChassis)chassis).getAWTComponent().repaint();
            }
            final boolean b = adapt;
            ThreadUtils.asyncExec((IThreadWorkQueue)AWTThread.getThreadAccess(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    node.setAdaptViewportToResizedControl(Boolean.valueOf(b));
                }
            });
        }
        return image;
    }

    private static Resource resolveModel(ReadGraph graph, Resource diagram) throws DatabaseException {
        ModelingResources mod = ModelingResources.getInstance((ReadGraph)graph);
        Resource composite = graph.getSingleObject(diagram, mod.DiagramToComposite);
        Resource model = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(composite));
        if (model == null) {
            throw new ValidationException("no model found for composite " + NameUtils.getSafeName((ReadGraph)graph, (Resource)composite));
        }
        return model;
    }

    private static String resolveRVI(ReadGraph graph, Resource diagram) throws DatabaseException {
        ModelingResources mod = ModelingResources.getInstance((ReadGraph)graph);
        Resource composite = graph.getSingleObject(diagram, mod.DiagramToComposite);
        ResourceArray compositePath = StructuralVariables.getCompositeArray((ReadGraph)graph, (Resource)composite);
        ResourceArray variablePath = compositePath.removeFromBeginning(1);
        return StructuralVariables.getRVI((ReadGraph)graph, (ResourceArray)variablePath);
    }

    public static class ImageExportPlan {
        public File exportLocation;
        public String name;
        public Resource diagram;
        public Double dpi;
        public Point size;
        public double margin;
    }
}

