/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.elements;

import gnu.trove.list.array.TIntArrayList;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import org.simantics.datatypes.literal.Font;
import org.simantics.datatypes.literal.RGB;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.diagram.elements.DiagramNodeUtil;
import org.simantics.diagram.elements.EditDataNode;
import org.simantics.diagram.elements.ITextContentFilter;
import org.simantics.diagram.elements.ITextListener;
import org.simantics.diagram.elements.Line;
import org.simantics.diagram.elements.TextEditActivation;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.element.IElement;
import org.simantics.scenegraph.IDynamicSelectionPainterNode;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.LoaderNode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.G2DPDFRenderingHints;
import org.simantics.scenegraph.g2d.G2DRenderingHints;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.utils.G2DUtils;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.Function2;
import org.simantics.ui.colors.Colors;
import org.simantics.ui.dnd.LocalObjectTransferable;
import org.simantics.ui.dnd.MultiTransferable;
import org.simantics.ui.dnd.PlaintextTransfer;
import org.simantics.ui.fonts.Fonts;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;

public class TextNode
extends G2DNode
implements IDynamicSelectionPainterNode,
LoaderNode {
    private static final long serialVersionUID = 654692698101485672L;
    private static final BasicStroke RESET_STROKE = new BasicStroke(1.0f);
    private static final AlphaComposite SrcOver_50 = AlphaComposite.SrcOver.derive(0.5f);
    protected static final FontRenderContext FRC = new FontRenderContext(new AffineTransform(), true, true);
    private static final java.awt.Font FONT = java.awt.Font.decode("Arial 6");
    private static final Color SELECTION_BACKGROUND_COLOR = new Color(3238597);
    protected String text = null;
    protected java.awt.Font font = FONT;
    protected Color color = Color.BLACK;
    protected Color backgroundColor = null;
    protected Color borderColor = null;
    protected double scale = 1.0;
    protected transient double scaleRecip = 1.0;
    protected float borderWidth = 0.0f;
    protected double paddingX = 2.0;
    protected double paddingY = 2.0;
    protected byte horizontalAlignment = 0;
    protected byte verticalAlignment = (byte)3;
    protected static final int STATE_PENDING = 1;
    protected static final int STATE_HOVER = 2;
    protected static final int STATE_EDITABLE = 4;
    protected static final int STATE_SHOW_SELECTION = 8;
    protected static final int STATE_WRAP_TEXT = 16;
    protected static final transient int STATE_EDITING = 32;
    protected static final transient int STATE_VALID = 64;
    protected static final transient int STATE_X_OFFSET_IS_DIRTY = 128;
    protected static final int STATE_ALWAYS_ADD_LISTENERS = 256;
    protected static final int STATE_LISTENERS_ADDED = 512;
    protected static final int STATE_AUTOMATIC_TEXT_FLIP_ENABLED = 1024;
    protected static final int STATE_AUTOMATIC_TEXT_FLIP_VERTICAL_DOWN = 2048;
    protected int state = 216;
    protected RVI dataRVI = null;
    int caret = 0;
    int selectionTail = 0;
    float xOffset = 0.0f;
    float fixedWidth = 0.0f;
    private Rectangle2D targetBounds;
    transient Function1<String, String> validator;
    transient ITextListener textListener;
    transient ITextContentFilter editContentFilter;
    protected transient Line[] lines = null;
    protected transient FontMetrics fontMetrics = null;
    private transient String textBeforeEdit = null;
    protected transient TextEditActivation editActivation;
    private transient Rectangle2D lastBounds = new Rectangle2D.Double();
    private transient Rectangle2D tightBoundsCache = null;
    private boolean elementBasedFocus = false;
    private static transient ThreadLocal<Rectangle2D> tempBounds = new ThreadLocal<Rectangle2D>(){

        @Override
        protected Rectangle2D initialValue() {
            return new Rectangle2D.Double();
        }
    };
    private static transient ThreadLocal<AffineTransform> tempAffineTransform = new ThreadLocal<AffineTransform>(){

        @Override
        protected AffineTransform initialValue() {
            return new AffineTransform();
        }
    };
    protected transient int hoverClick = 0;
    boolean dragged = false;
    private MouseEvent lastMouseEvent = null;

    public void init() {
        super.init();
        NodeUtil.increasePending((INode)this);
    }

    public void cleanup() {
        this.removeListeners();
        super.cleanup();
    }

    protected boolean hasState(int flags) {
        return (this.state & flags) == flags;
    }

    protected void setState(int flags) {
        this.state |= flags;
    }

    protected void setState(int flags, boolean set) {
        this.state = set ? (this.state |= flags) : (this.state &= ~flags);
    }

    protected void clearState(int flags) {
        this.state &= ~flags;
    }

    protected void setListeners(boolean add) {
        if (add) {
            this.addListeners();
        } else {
            this.removeListeners();
        }
    }

    protected void addListeners() {
        if (!this.hasState(512)) {
            this.addEventHandler((IEventHandler)this);
            this.setState(512);
        }
    }

    protected void removeListeners() {
        if (this.hasState(512)) {
            this.removeEventHandler((IEventHandler)this);
            this.clearState(512);
        }
    }

    public void setForceEventListening(boolean force) {
        this.setState(256, force);
        if (force && !this.hasState(4)) {
            this.setListeners(force);
        }
    }

    public void setElementBasedFocus(boolean elementBasedFocus) {
        this.elementBasedFocus = elementBasedFocus;
    }

    public Boolean setEditMode(boolean edit) {
        return this.setEditMode(edit, true);
    }

    protected Boolean setEditMode(boolean edit, boolean notify) {
        if (edit && !this.hasState(4)) {
            return null;
        }
        if (this.hasState(32) == edit) {
            return null;
        }
        this.setState(32, edit);
        if (edit) {
            this.caret = this.text != null ? this.text.length() : 0;
            this.selectionTail = 0;
            this.textBeforeEdit = this.text;
            if (notify) {
                this.fireTextEditingStarted();
            }
            return Boolean.TRUE;
        }
        if (notify) {
            this.fireTextEditingEnded();
        }
        return Boolean.FALSE;
    }

    @INode.SyncField(value={"editable"})
    public void setEditable(boolean editable) {
        boolean changed = this.hasState(4) ^ editable;
        this.setState(4, editable);
        if (this.hasState(32) && !editable) {
            this.setEditMode(false);
        }
        if (changed && !this.hasState(256)) {
            this.setListeners(editable);
        }
    }

    public boolean isEditable() {
        return this.hasState(4);
    }

    public boolean isEditMode() {
        return this.hasState(32);
    }

    @INode.SyncField(value={"wrapText"})
    public void setWrapText(boolean wrapText) {
        this.setState(16, wrapText);
    }

    public boolean isWrapText() {
        return this.hasState(16);
    }

    @INode.SyncField(value={"showSelection"})
    public void setShowSelection(boolean showSelection) {
        this.setState(8, showSelection);
    }

    public boolean showsSelection() {
        return this.hasState(8) && !this.elementBasedFocus;
    }

    @INode.SyncField(value={"text", "font", "color", "x", "y", "scale"})
    public void init(String text, java.awt.Font font, Color color, double x, double y, double scale) {
        if (this.text == null && text != null) {
            NodeUtil.decreasePending((INode)this);
        }
        if (this.hasState(32)) {
            return;
        }
        this.text = text;
        this.font = font;
        this.color = color;
        this.scale = scale;
        this.scaleRecip = 1.0 / scale;
        this.caret = 0;
        this.selectionTail = 0;
        this.resetCaches();
    }

    public void setAutomaticTextFlipping(TextFlipping type) {
        switch (type) {
            case Disabled: {
                this.clearState(3072);
                break;
            }
            case VerticalTextDownwards: {
                this.setState(3072);
                break;
            }
            case VerticalTextUpwards: {
                this.setState(1024);
                this.clearState(2048);
            }
        }
    }

    @INode.SyncField(value={"paddingX", "paddingY"})
    public void setPadding(double x, double y) {
        this.paddingX = x;
        this.paddingY = y;
    }

    @INode.SyncField(value={"color"})
    public void setColor(Color color) {
        this.color = color;
    }

    @INode.SyncField(value={"backgroundColor"})
    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    @INode.SyncField(value={"borderColor"})
    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public String getText() {
        return this.text;
    }

    public String getTextBeforeEdit() {
        return this.textBeforeEdit;
    }

    @INode.SyncField(value={"text", "caret", "selectionTail"})
    public void setText(String text) {
        if (this.hasState(32)) {
            return;
        }
        if (this.text != null && text == null) {
            NodeUtil.increasePending((INode)this);
        }
        if (this.text == null && text != null) {
            NodeUtil.decreasePending((INode)this);
        }
        this.text = text;
        this.selectionTail = this.caret = text != null ? Math.min(this.caret, text.length()) : 0;
        this.resetCaches();
    }

    @INode.SyncField(value={"pending"})
    public void setPending(boolean pending) {
        boolean p = this.hasState(1);
        if (!p && pending) {
            NodeUtil.increasePending((INode)this);
        }
        if (p && !pending) {
            NodeUtil.decreasePending((INode)this);
        }
        if (p != pending) {
            this.setState(1, pending);
        }
    }

    @INode.SyncField(value={"fixedWidth"})
    public void setFixedWidth(float fixedWidth) {
        if (fixedWidth < 0.0f) {
            throw new IllegalArgumentException("negative fixed width");
        }
        this.fixedWidth = fixedWidth;
        this.invalidateXOffset();
    }

    public void setTargetBounds(Rectangle2D bounds) {
        this.targetBounds = bounds;
    }

    public final void synchronizeWidth(float width) {
        if (width >= 0.0f) {
            this.setFixedWidth(width);
        }
    }

    public final void synchronizeBorderWidth(float width) {
        if (width >= 0.0f) {
            this.setBorderWidth(width);
        }
    }

    public final void synchronizeWrapText(boolean wrap) {
        this.setState(16, wrap);
    }

    public boolean isHovering() {
        return this.hasState(2);
    }

    @INode.SyncField(value={"hover"})
    public void setHover(boolean hover) {
        this.setState(2, hover);
        this.repaint();
    }

    public java.awt.Font getFont() {
        return this.font;
    }

    @INode.SyncField(value={"font"})
    public void setFont(java.awt.Font font) {
        this.font = font;
        this.resetCaches();
    }

    public double getBorderWidth() {
        return this.borderWidth;
    }

    @INode.SyncField(value={"borderWidth"})
    public void setBorderWidth(float width) {
        this.borderWidth = width;
    }

    public void setBorderWidth(double width) {
        this.setBorderWidth((float)width);
    }

    @INode.SyncField(value={"horizontalAlignment"})
    public void setHorizontalAlignment(byte horizontalAlignment) {
        if (horizontalAlignment < 0 && horizontalAlignment > 2) {
            throw new IllegalArgumentException("Invalid horizontal alignment: " + horizontalAlignment + ", must be between 0 and 2");
        }
        this.horizontalAlignment = horizontalAlignment;
        this.resetCaches();
    }

    public final void synchronizeHorizontalAlignment(byte horizontalAlignment) {
        if (horizontalAlignment >= 0 && horizontalAlignment <= 2) {
            this.setHorizontalAlignment(horizontalAlignment);
        }
    }

    public byte getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @INode.SyncField(value={"verticalAlignment"})
    public void setVerticalAlignment(byte verticalAlignment) {
        if (verticalAlignment < 0 && verticalAlignment > 3) {
            throw new IllegalArgumentException("Invalid vertical alignment: " + verticalAlignment + ", must be between 0 and 3");
        }
        this.verticalAlignment = verticalAlignment;
        this.resetCaches();
    }

    public final void synchronizeVerticalAlignment(byte verticalAlignment) {
        if (verticalAlignment >= 0 && verticalAlignment <= 3) {
            this.setVerticalAlignment(verticalAlignment);
        }
    }

    public byte getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void render(Graphics2D g) {
        AffineTransform ot = g.getTransform();
        this.render(g, true);
        g.setTransform(ot);
    }

    public void render(Graphics2D g, boolean applyTransform) {
        Color backgroundColor;
        float textSizeMM;
        Object renderingHint;
        AffineTransform curTr;
        double currentScale;
        if (this.text == null || this.font == null || this.color == null) {
            return;
        }
        if (this.fontMetrics == null) {
            this.fontMetrics = g.getFontMetrics(this.font);
        }
        Color color = this.color;
        boolean isSelected = NodeUtil.isSelected((INode)this, (int)1);
        boolean hover = this.hasState(2);
        boolean editing = this.hasState(32);
        if (!this.elementBasedFocus && !isSelected && hover && this.textListener != null) {
            color = this.add(color, 120, 120, 120);
        }
        if (applyTransform) {
            g.transform(this.transform);
        }
        if (this.scale != 1.0) {
            g.scale(this.scale, this.scale);
        }
        if ((currentScale = GeometryUtils.getScale((AffineTransform)(curTr = g.getTransform()))) < 1.0E-6) {
            return;
        }
        g.setFont(this.font);
        Rectangle2D r = this.getTightAlignedBoundsInLocal(tempBounds.get(), this.fontMetrics.getFontRenderContext());
        this.computeEditingXOffset();
        if (this.fixedWidth > 0.0f) {
            r.setFrame(r.getMinX(), r.getMinY(), this.fixedWidth, r.getHeight());
        }
        if (this.targetBounds != null) {
            double w = (this.targetBounds.getWidth() - this.paddingX * 2.0) * this.scaleRecip;
            double h = (this.targetBounds.getHeight() - this.paddingY * 2.0) * this.scaleRecip;
            double x = (this.targetBounds.getMinX() + this.paddingX) * this.scaleRecip;
            double y = (this.targetBounds.getMinY() + this.paddingY) * this.scaleRecip;
            r.setRect(x, y, w, h);
        }
        if (this.hasState(1024)) {
            boolean needsYFlip;
            boolean needsXFlip;
            if (curTr.getScaleX() != 0.0) {
                needsXFlip = curTr.getScaleX() < 0.0;
                needsYFlip = curTr.getScaleY() < 0.0;
            } else {
                boolean flipAll = !this.hasState(2048);
                needsXFlip = curTr.getShearY() < 0.0 ^ flipAll;
                needsYFlip = curTr.getShearX() > 0.0 ^ flipAll;
            }
            if (needsXFlip || needsYFlip) {
                double centerX = r.getWidth() * 0.5 + r.getX();
                double centerY = r.getHeight() * 0.5 + r.getY();
                g.translate(centerX, centerY);
                g.scale(needsXFlip ? -1.0 : 1.0, needsYFlip ? -1.0 : 1.0);
                g.translate(-centerX, -centerY);
            }
        }
        boolean renderText = true;
        if (!editing && (renderingHint = g.getRenderingHint(RenderingHints.KEY_RENDERING)) != RenderingHints.VALUE_RENDER_QUALITY && (textSizeMM = (float)currentScale * GeometryUtils.pointToMillimeter((float)this.font.getSize2D())) < 1.5f) {
            renderText = false;
        }
        boolean clippingDisabled = Boolean.TRUE.equals(g.getRenderingHint((RenderingHints.Key)G2DRenderingHints.KEY_TEXT_DISABLE_CLIPPING));
        Shape clipSave = null;
        if (!clippingDisabled) {
            clipSave = g.getClip();
            g.setClip(r);
        }
        Object writer = g.getRenderingHint(G2DPDFRenderingHints.KEY_PDF_WRITER);
        G2DRenderingHints.TextRenderingMode renderingMode = (G2DRenderingHints.TextRenderingMode)g.getRenderingHint((RenderingHints.Key)G2DRenderingHints.KEY_TEXT_RENDERING_MODE);
        boolean renderAsText = writer != null || renderingMode == G2DRenderingHints.TextRenderingMode.AS_TEXT;
        Color color2 = backgroundColor = this.hasState(64) ? this.backgroundColor : Color.red;
        if (backgroundColor != null) {
            g.setColor(backgroundColor);
            g.fill(r);
        }
        if (editing) {
            int selectionMin = Math.min(this.caret, this.selectionTail);
            int selectionMax = Math.max(this.caret, this.selectionTail);
            g.setColor(color);
            this.renderText(g, this.xOffset, renderAsText);
            Shape clip = g.getClip();
            Line[] lineArray = this.lines;
            int n = this.lines.length;
            int n2 = 0;
            while (n2 < n) {
                Line line = lineArray[n2];
                if (line.intersectsRange(selectionMin, selectionMax)) {
                    Shape selShape = line.getLogicalHighlightShape(selectionMin, selectionMax);
                    line.translate(g, this.xOffset, 0.0f);
                    g.setClip(selShape);
                    g.setColor(SELECTION_BACKGROUND_COLOR);
                    g.fill(selShape);
                    g.setColor(Color.WHITE);
                    if (renderAsText) {
                        g.drawString(line.getText(), 0, 0);
                    } else {
                        line.layout.draw(g, 0.0f, 0.0f);
                    }
                    line.translateInv(g, this.xOffset, 0.0f);
                }
                ++n2;
            }
            g.setClip(clip);
            this.renderCaret(g);
        } else if (renderText) {
            g.setColor(color);
            this.renderText(g, 0.0f, renderAsText);
        }
        if (!clippingDisabled) {
            g.setClip(clipSave);
        }
        if (this.borderWidth > 0.0f && this.borderColor != null) {
            g.setColor(this.borderColor);
            g.setStroke(new BasicStroke((float)(this.scale * (double)this.borderWidth)));
            g.draw(r);
        }
        if (isSelected && this.showsSelection() && g.getRenderingHint((RenderingHints.Key)G2DRenderingHints.KEY_HIDE_SELECTION) != Boolean.TRUE) {
            Composite oc = g.getComposite();
            g.setComposite(SrcOver_50);
            g.setColor(Color.RED);
            float bw = this.borderWidth;
            double s = currentScale;
            bw = bw <= 0.0f ? (float)(1.0 / s) : (float)((double)bw * (5.0 * this.scale));
            g.setStroke(new BasicStroke(bw));
            g.draw(r);
            g.setComposite(oc);
        }
        g.scale(this.scaleRecip, this.scaleRecip);
        g.setStroke(RESET_STROKE);
        this.lastBounds = this.getScaledOffsetBounds(r, this.lastBounds, this.scale, 0.0, 0.0);
        this.renderSelectedHover(g, isSelected, hover);
    }

    private void renderCaret(Graphics2D g) {
        g.setColor(Color.BLACK);
        int i = 0;
        while (i < this.lines.length) {
            Line line = this.lines[i];
            if (line.containsOffset(this.caret) && (this.caret != line.endOffset || i == this.lines.length - 1 || this.lines[i + 1].startOffset != line.endOffset)) {
                Shape[] caretShape = line.getCaretShapes(this.caret);
                line.translate(g, this.xOffset, 0.0f);
                g.draw(caretShape[0]);
                if (caretShape[1] != null) {
                    g.draw(caretShape[1]);
                }
                line.translateInv(g, this.xOffset, 0.0f);
            }
            ++i;
        }
    }

    private void renderText(Graphics2D g, float xOffset, boolean renderAsText) {
        Line[] lineArray = this.lines;
        int n = this.lines.length;
        int n2 = 0;
        while (n2 < n) {
            Line line = lineArray[n2];
            if (renderAsText) {
                g.drawString(line.getText(), line.alignedPosX + xOffset, line.alignedPosY);
            } else {
                line.layout.draw(g, line.alignedPosX + xOffset, line.alignedPosY);
            }
            ++n2;
        }
    }

    protected Rectangle2D getScaledOffsetBounds(Rectangle2D originalBounds, Rectangle2D dst, double scale, double offsetX, double offsetY) {
        AffineTransform btr = tempAffineTransform.get();
        btr.setToTranslation(offsetX * scale, offsetY * scale);
        btr.scale(scale, scale);
        if (btr.isIdentity()) {
            dst.setFrame(originalBounds);
        } else {
            dst.setFrame(btr.createTransformedShape(originalBounds).getBounds2D());
        }
        return dst;
    }

    protected void renderSelectedHover(Graphics2D g, boolean isSelected, boolean isHovering) {
    }

    public String editText(String text) {
        String error;
        String string = error = this.validator != null ? (String)this.validator.apply((Object)text) : null;
        if (error == null) {
            this.text = text;
            if (this.textListener != null) {
                this.textListener.textEditingEnded();
            }
        }
        return error;
    }

    @INode.SyncField(value={"text", "caret", "selectionTail"})
    protected void insert(String content) {
        content = this.editContentFilter != null ? this.editContentFilter.filter(this, content) : content;
        int selectionMin = Math.min(this.caret, this.selectionTail);
        int selectionMax = Math.max(this.caret, this.selectionTail);
        String begin = this.text.substring(0, selectionMin);
        String end = this.text.substring(selectionMax);
        this.text = begin + content + end;
        this.selectionTail = this.caret = selectionMin + content.length();
        assert (this.caret <= this.text.length());
        if (this.validator != null) {
            String error = (String)this.validator.apply((Object)this.text);
            this.setState(64, error == null);
        }
        this.resetCaches();
    }

    @INode.ServerSide
    protected void fireTextChanged() {
        if (this.textListener != null) {
            this.textListener.textChanged();
        }
        this.repaint();
    }

    @INode.ServerSide
    protected void fireTextEditingStarted() {
        if (this.textListener != null) {
            this.textListener.textEditingStarted();
        }
    }

    @INode.ServerSide
    protected void fireTextEditingCancelled() {
        this.setState(64);
        if (this.deactivateEdit()) {
            if (this.textListener != null) {
                this.textListener.textEditingCancelled();
            }
            this.setEditMode(false, false);
            if (this.textBeforeEdit != null) {
                this.setText(this.textBeforeEdit);
            }
            this.repaint();
        }
    }

    @INode.ServerSide
    public void fireTextEditingEnded() {
        if (!this.hasState(64)) {
            this.fireTextEditingCancelled();
            this.setState(64);
            return;
        }
        if (this.deactivateEdit()) {
            if (this.textListener != null) {
                this.textListener.textEditingEnded();
            }
            this.setEditMode(false, false);
            this.repaint();
        }
    }

    public void setTextListener(ITextListener listener) {
        this.textListener = listener;
    }

    public void setValidator(Function1<String, String> validator) {
        this.validator = validator;
    }

    public void setContentFilter(ITextContentFilter filter) {
        this.editContentFilter = filter;
    }

    public void setRVI(RVI rvi) {
        this.dataRVI = rvi;
    }

    private void invalidateXOffset() {
        this.setState(128);
    }

    private void computeEditingXOffset() {
        if (this.lines == null) {
            return;
        }
        if (!this.hasState(128)) {
            return;
        }
        if (!(this.fixedWidth > 0.0f)) {
            this.xOffset = 0.0f;
        }
        this.clearState(128);
    }

    @INode.SyncField(value={"caret", "selectionTail"})
    protected void moveCaret(int move, boolean select) {
        if (move > 0) {
            while (this.text.length() > this.caret + move && this.getLineSeparator().indexOf(this.text.charAt(this.caret + move)) > 0) {
                ++move;
            }
        } else if (move < 0) {
            while (this.caret + move >= 0 && this.text.length() > this.caret + move && this.getLineSeparator().indexOf(this.text.charAt(this.caret + move)) > 0) {
                --move;
            }
        }
        this.caret += move;
        if (this.caret < 0) {
            this.caret = 0;
        }
        if (this.caret > this.text.length()) {
            this.caret = this.text.length();
        }
        if (!select) {
            this.selectionTail = this.caret;
        }
    }

    private Line findCaretLine() {
        int i = 0;
        while (i < this.lines.length) {
            Line line = this.lines[i];
            if (this.caret <= line.endOffset) {
                return line;
            }
            ++i;
        }
        return null;
    }

    private void moveCaretCtrlLeft(boolean shiftDown) {
        Line line = this.findCaretLine();
        if (line != null) {
            int i = this.caret - 1;
            while (i > line.startOffset) {
                char c = line.document.charAt(i);
                if (!Character.isLetterOrDigit(c)) break;
                --i;
            }
            this.moveCaret(i - this.caret, shiftDown);
        }
    }

    private void moveCaretCtrlRight(boolean shiftDown) {
        Line line = this.findCaretLine();
        if (line != null) {
            int i = this.caret + 1;
            while (i < line.endOffset) {
                char c = line.document.charAt(i);
                if (!Character.isLetterOrDigit(c)) break;
                ++i;
            }
            this.moveCaret(i - this.caret, shiftDown);
        }
    }

    private void moveCaretEnd(boolean shiftDown) {
        Line line = this.findCaretLine();
        if (line != null) {
            this.moveCaret(line.endOffset - this.caret, shiftDown);
        }
    }

    private void moveCaretHome(boolean shiftDown) {
        Line line = this.findCaretLine();
        if (line != null) {
            this.moveCaret(line.startOffset - this.caret, shiftDown);
        }
    }

    private void moveCaretRowUp(boolean shiftDown) {
        int i = 0;
        while (i < this.lines.length) {
            Line line = this.lines[i];
            if (this.caret <= line.endOffset) {
                if (i == 0) {
                    this.moveCaret(-this.caret, shiftDown);
                    break;
                }
                Line prevLine = this.lines[i - 1];
                int prevLength = prevLine.endOffset - prevLine.startOffset;
                int posInCurRow = this.caret - line.startOffset;
                if (prevLength < posInCurRow) {
                    posInCurRow = prevLength;
                }
                int newPos = prevLine.startOffset + posInCurRow;
                this.moveCaret(newPos - this.caret, shiftDown);
                break;
            }
            ++i;
        }
    }

    private void moveCaretRowDown(boolean shiftDown) {
        int i = this.lines.length - 1;
        while (i >= 0) {
            Line line = this.lines[i];
            if (this.caret >= line.startOffset) {
                if (i == this.lines.length - 1) {
                    this.moveCaret(line.endOffset - this.caret, shiftDown);
                    break;
                }
                Line prevLine = this.lines[i + 1];
                int prevLength = prevLine.endOffset - prevLine.startOffset;
                int posInCurRow = this.caret - line.startOffset;
                if (prevLength < posInCurRow) {
                    posInCurRow = prevLength;
                }
                int newPos = prevLine.startOffset + posInCurRow;
                this.moveCaret(newPos - this.caret, shiftDown);
                break;
            }
            --i;
        }
    }

    @INode.SyncField(value={"caret", "selectionTail"})
    protected void setCaret(int pos, boolean select) {
        this.caret = pos;
        if (this.caret < 0) {
            this.caret = 0;
        }
        if (this.caret > this.text.length()) {
            this.caret = this.text.length();
        }
        if (!select) {
            this.selectionTail = this.caret;
        }
    }

    protected void setCaret(Point2D point) {
        this.setCaret(point, false);
    }

    @INode.SyncField(value={"caret", "selectionTail"})
    protected void setCaret(Point2D point, boolean select) {
        double lineY = 0.0;
        int i = 0;
        while (i < this.lines.length) {
            Line line = this.lines[i];
            Rectangle2D bounds = line.abbox;
            lineY = i == 0 ? bounds.getY() : (lineY += this.lines[i - 1].abbox.getHeight());
            double lineHeight = bounds.getHeight();
            double hitY = point.getY() / this.scale;
            if (hitY >= lineY && hitY <= lineY + lineHeight) {
                float x = (float)(point.getX() / this.scale) - (float)line.abbox.getX();
                float y = (float)(point.getY() / this.scale - lineHeight * (double)i);
                TextHitInfo info = line.layout.hitTestChar(x, y);
                this.caret = line.startOffset + info.getInsertionIndex();
                if (this.caret > line.endOffset) {
                    this.caret = line.endOffset;
                }
                if (!select) {
                    this.selectionTail = this.caret;
                }
                this.repaint();
                break;
            }
            ++i;
        }
        this.invalidateXOffset();
        assert (this.caret <= this.text.length());
    }

    public Rectangle2D getBoundsInLocal() {
        if (this.targetBounds != null) {
            return this.targetBounds;
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        this.getTightAlignedBoundsInLocal(bounds);
        bounds.setFrame(((RectangularShape)bounds).getX() * this.scale, ((RectangularShape)bounds).getY() * this.scale, ((RectangularShape)bounds).getWidth() * this.scale, ((RectangularShape)bounds).getHeight() * this.scale);
        return bounds;
    }

    protected Rectangle2D expandBounds(Rectangle2D r) {
        r.setRect(r.getX() * this.scale - this.paddingX, r.getY() * this.scale - this.paddingY, r.getWidth() * this.scale + this.paddingX + this.paddingX, r.getHeight() * this.scale + this.paddingY + this.paddingY);
        return r;
    }

    protected Rectangle2D expandBoundsUnscaled(Rectangle2D r) {
        r.setRect(r.getX() - this.scaleRecip * this.paddingX, r.getY() - this.scaleRecip * this.paddingY, r.getWidth() + this.scaleRecip * this.paddingX + this.scaleRecip * this.paddingX, r.getHeight() + this.scaleRecip * this.paddingY + this.scaleRecip * this.paddingY);
        return r;
    }

    protected Rectangle2D expandBounds(Rectangle2D r, double amount) {
        r.setRect(r.getX() - amount, r.getY() - amount, r.getWidth() + 2.0 * amount, r.getHeight() + 2.0 * amount);
        return r;
    }

    protected Rectangle2D expandBounds(Rectangle2D r, double left, double top, double right, double bottom) {
        r.setRect(r.getX() - left, r.getY() - top, r.getWidth() + left + right, r.getHeight() + top + bottom);
        return r;
    }

    private void resetCaches() {
        this.tightBoundsCache = null;
        this.lines = null;
        this.fontMetrics = null;
    }

    protected Rectangle2D getTightAlignedBoundsInLocal(Rectangle2D r) {
        return this.getTightAlignedBoundsInLocal(r, FRC);
    }

    protected Rectangle2D getTightAlignedBoundsInLocal(Rectangle2D r, FontRenderContext frc) {
        if (r == null) {
            r = new Rectangle2D.Double();
        }
        if (this.tightBoundsCache != null) {
            r.setFrame(this.tightBoundsCache);
            return r;
        }
        String txt = this.text;
        if (this.font == null || txt == null) {
            r.setFrame(0.0, 0.0, 2.0, 1.0);
            return r;
        }
        Line[] lines = null;
        if (this.hasState(16)) {
            float width = this.fixedWidth;
            if (width <= 0.0f && this.targetBounds != null) {
                width = (float)((this.targetBounds.getWidth() - 2.0 * this.paddingX) * this.scaleRecip);
            }
            if (width > 0.0f) {
                lines = TextNode.wrapLines(txt, this.font, width, frc);
            }
        }
        if (lines == null) {
            lines = TextNode.parseLines(txt);
        }
        this.lines = this.layoutLines(lines, frc);
        this.tightBoundsCache = this.calculateBounds(lines, Line.BBOX, null);
        this.lines = this.layoutLinesX(lines, this.tightBoundsCache);
        this.lines = this.alignLines(this.lines, this.tightBoundsCache, this.horizontalAlignment, this.verticalAlignment);
        this.calculateBounds(lines, Line.ABBOX, this.tightBoundsCache);
        r.setFrame(this.tightBoundsCache);
        return r;
    }

    private Line[] layoutLinesX(Line[] lines, Rectangle2D bbox) {
        int lineCount = lines.length;
        int l = 0;
        while (l < lineCount) {
            Line line = lines[l];
            line.drawPosX = (float)(line.layout.isLeftToRight() ? 0.0 : this.tightBoundsCache.getWidth() - (double)line.layout.getAdvance());
            ++l;
        }
        return lines;
    }

    private Rectangle2D calculateBounds(Line[] lines, Line.BoundsProcedure boundsProvider, Rectangle2D result) {
        if (result == null) {
            result = new Rectangle2D.Double();
        } else {
            result.setFrame(0.0, 0.0, 0.0, 0.0);
        }
        Line[] lineArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            Line line = lineArray[n2];
            Rectangle2D bbox = boundsProvider.getBounds(line);
            if (result.isEmpty()) {
                result.setFrame(bbox);
            } else {
                Rectangle2D.union(result, bbox, result);
            }
            ++n2;
        }
        return result;
    }

    private Line[] alignLines(Line[] lines, Rectangle2D bbox, byte hAlign, byte vAlign) {
        double xbase = 0.0;
        if (this.targetBounds != null) {
            switch (hAlign) {
                case 1: {
                    xbase = (this.targetBounds.getMaxX() - this.paddingX) * this.scaleRecip;
                    break;
                }
                case 2: {
                    xbase = this.targetBounds.getCenterX() * this.scaleRecip;
                    break;
                }
            }
        }
        Line[] lineArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            Line line = lineArray[n2];
            double xoffset = 0.0;
            double yoffset = 0.0;
            switch (hAlign) {
                case 1: {
                    xoffset = xbase - line.bbox.getWidth();
                    break;
                }
                case 2: {
                    xoffset = xbase - line.bbox.getWidth() / 2.0;
                    break;
                }
            }
            switch (vAlign) {
                case 0: {
                    yoffset = line.layout.getAscent();
                    break;
                }
                case 1: {
                    yoffset = -bbox.getHeight() + (double)line.layout.getAscent();
                    break;
                }
                case 2: {
                    yoffset = -bbox.getHeight() / 2.0 + (double)line.layout.getAscent();
                }
            }
            line.alignOffset(xoffset, yoffset);
            ++n2;
        }
        return lines;
    }

    private Line[] layoutLines(Line[] lines, FontRenderContext frc) {
        TextLayout emptyRowLayout = null;
        int lineCount = lines.length;
        float y = 0.0f;
        int l = 0;
        while (l < lineCount) {
            Line line = lines[l];
            String lineText = line.getText();
            if (lineText.isEmpty()) {
                lineText = " ";
                if (emptyRowLayout == null) {
                    emptyRowLayout = new TextLayout(lineText, this.font, frc);
                }
                line.layout = emptyRowLayout;
            } else {
                line.layout = new TextLayout(lineText, this.font, frc);
            }
            line.drawPosY = y;
            y += line.layout.getDescent() + line.layout.getLeading() + line.layout.getAscent();
            Rectangle2D bbox = line.layout.getLogicalHighlightShape(0, lineText.length()).getBounds2D();
            Rectangle2D bbox2 = line.layout.getBounds();
            bbox.add(bbox2);
            bbox.setFrame(bbox.getX(), bbox.getY() + (double)line.drawPosY, bbox.getWidth(), bbox.getHeight());
            line.bbox = bbox;
            ++l;
        }
        return lines;
    }

    private static Line[] parseLines(String txt) {
        int len = txt.length();
        if (len == 0) {
            return new Line[]{new Line("", 0, 0)};
        }
        TIntArrayList lfpos = new TIntArrayList();
        int pos = 0;
        int lineCount = 1;
        while (pos < len) {
            int nextlf = txt.indexOf(10, pos);
            lfpos.add(nextlf != -1 ? nextlf : len);
            if (nextlf == -1) break;
            pos = nextlf + 1;
            ++lineCount;
        }
        Line[] lines = new Line[lineCount];
        pos = 0;
        int i = 0;
        while (i < lineCount - 1) {
            int lf = lfpos.getQuick(i);
            int cr = lf > 0 && txt.charAt(lf - 1) == '\r' ? lf - 1 : lf;
            lines[i] = new Line(txt, pos, cr);
            pos = lf + 1;
            ++i;
        }
        lines[lineCount - 1] = new Line(txt, pos, len);
        return lines;
    }

    private static Line[] wrapLines(String txt, java.awt.Font font, float fixedWidth, FontRenderContext frc) {
        if (txt == null || txt.isEmpty()) {
            txt = " ";
        }
        ArrayList<Line> lines = new ArrayList<Line>();
        Hashtable<TextAttribute, java.awt.Font> map = new Hashtable<TextAttribute, java.awt.Font>();
        map.put(TextAttribute.FONT, font);
        AttributedString attributedText = new AttributedString(txt.isEmpty() ? "__ERROR__" : txt, map);
        AttributedCharacterIterator paragraph = attributedText.getIterator();
        int paragraphStart = paragraph.getBeginIndex();
        int paragraphEnd = paragraph.getEndIndex();
        LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(paragraph, frc);
        float breakWidth = fixedWidth;
        lineMeasurer.setPosition(paragraphStart);
        int position = 0;
        while ((position = lineMeasurer.getPosition()) < paragraphEnd) {
            int next;
            int limit = next = lineMeasurer.nextOffset(breakWidth);
            int charat = txt.indexOf(System.getProperty("line.separator"), position + 1);
            if (charat < next && charat != -1) {
                limit = charat;
            }
            lineMeasurer.nextLayout(breakWidth, limit, false);
            lines.add(new Line(txt, position, limit));
        }
        return lines.toArray(new Line[lines.size()]);
    }

    public String getClipboardContent() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable clipData = clipboard.getContents((Object)this);
        try {
            return (String)clipData.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setClipboardContent(String content) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection data = new StringSelection(content);
        clipboard.setContents(data, data);
    }

    public String toString() {
        return super.toString() + " [text=" + this.text + ", font=" + String.valueOf(this.font) + ", color=" + String.valueOf(this.color) + "]";
    }

    protected boolean handleCommand(CommandEvent e) {
        if (!this.hasState(32)) {
            return false;
        }
        if (Commands.SELECT_ALL.equals((Object)e.command)) {
            this.selectAll();
            return true;
        }
        return false;
    }

    protected boolean keyPressed(KeyEvent.KeyPressedEvent event) {
        block35: {
            boolean alt;
            boolean ctrl;
            char c;
            block34: {
                if (!this.hasState(32)) {
                    return false;
                }
                c = event.character;
                ctrl = event.isControlDown();
                alt = event.isAltDown();
                if (!ctrl || alt) break block34;
                switch (event.keyCode) {
                    case 67: {
                        if (this.caret != this.selectionTail) {
                            int selectionMin = Math.min(this.caret, this.selectionTail);
                            int selectionMax = Math.max(this.caret, this.selectionTail);
                            this.setClipboardContent(this.text.substring(selectionMin, selectionMax));
                        }
                        break block35;
                    }
                    case 88: {
                        if (this.caret != this.selectionTail) {
                            int selectionMin = Math.min(this.caret, this.selectionTail);
                            int selectionMax = Math.max(this.caret, this.selectionTail);
                            this.setClipboardContent(this.text.substring(selectionMin, selectionMax));
                            this.insert("");
                        }
                        break block35;
                    }
                    case 39: {
                        if (c == '\u0000') {
                            this.moveCaretCtrlRight(event.isShiftDown());
                        }
                        break block35;
                    }
                    case 37: {
                        this.moveCaretCtrlLeft(event.isShiftDown());
                        break block35;
                    }
                    case 86: {
                        String content = this.getClipboardContent();
                        if (content != null) {
                            this.insert(content);
                        }
                        break block35;
                    }
                    case 10: {
                        this.insert(this.getLineSeparator());
                        break block35;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (!ctrl && alt) {
                return false;
            }
            switch (event.keyCode) {
                case 37: {
                    this.moveCaret(-1, event.isShiftDown());
                    break;
                }
                case 39: {
                    if (c == '\u0000') {
                        this.moveCaret(1, event.isShiftDown());
                        break;
                    }
                }
                case 38: {
                    this.moveCaretRowUp(event.isShiftDown());
                    break;
                }
                case 40: {
                    this.moveCaretRowDown(event.isShiftDown());
                    break;
                }
                case 36: {
                    this.moveCaretHome(event.isShiftDown());
                    break;
                }
                case 35: {
                    this.moveCaretEnd(event.isShiftDown());
                    break;
                }
                case 10: {
                    this.fireTextEditingEnded();
                    return true;
                }
                case 27: {
                    this.text = this.textBeforeEdit;
                    this.resetCaches();
                    this.clearState(32);
                    this.fireTextChanged();
                    this.fireTextEditingCancelled();
                    return true;
                }
                case 8: {
                    if (this.caret == this.selectionTail && this.caret > 0) {
                        String lineSep = this.getLineSeparator();
                        int index = lineSep.indexOf(this.text.charAt(this.caret - 1));
                        if (index == -1) {
                            --this.caret;
                        } else {
                            this.caret -= index + 1;
                            this.selectionTail += lineSep.length() - index - 1;
                        }
                    }
                    this.insert("");
                    break;
                }
                case 127: {
                    if (this.caret == this.selectionTail && this.caret < this.text.length()) {
                        String lineSep = this.getLineSeparator();
                        int index = lineSep.indexOf(this.text.charAt(this.caret));
                        if (index == -1) {
                            ++this.caret;
                        } else {
                            this.selectionTail -= index;
                            this.caret += lineSep.length() - index;
                        }
                    }
                    this.insert("");
                    break;
                }
                default: {
                    if (c == '\uffff' || Character.getType(c) == 15) {
                        return false;
                    }
                    this.insert(new String(new char[]{c}));
                }
            }
        }
        this.fireTextChanged();
        this.invalidateXOffset();
        return true;
    }

    protected String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    protected void selectAll() {
        this.setCaret(0, false);
        this.setCaret(this.text.length(), true);
    }

    protected boolean mouseClicked(MouseEvent.MouseClickEvent event) {
        if (this.dragged) {
            this.dragged = false;
            return false;
        }
        if (event.button != 1) {
            return false;
        }
        if (this.hasState(2)) {
            if (event.hasAnyModifier(128)) {
                return false;
            }
            if (!this.elementBasedFocus) {
                ++this.hoverClick;
                if (this.hoverClick < 2) {
                    return false;
                }
                ICanvasContext ctx = DiagramNodeUtil.getCanvasContext((IG2DNode)this);
                if (ctx == null) {
                    return false;
                }
                IElement e = DiagramNodeUtil.getElement(ctx, (IG2DNode)this);
                if (!this.hasState(32) && Boolean.TRUE.equals(this.setEditMode(true))) {
                    this.editActivation = this.activateEdit(0, e, ctx);
                    this.repaint();
                }
                return true;
            }
            if (NodeUtil.isSelected((INode)this, (int)1)) {
                ICanvasContext ctx = DiagramNodeUtil.getCanvasContext((IG2DNode)this);
                if (ctx == null) {
                    return false;
                }
                IElement e = DiagramNodeUtil.getElement(ctx, (IG2DNode)this);
                if (!this.hasState(32) && Boolean.TRUE.equals(this.setEditMode(true))) {
                    this.editActivation = this.activateEdit(0, e, ctx);
                    this.repaint();
                }
                return true;
            }
            return false;
        }
        this.hoverClick = 0;
        if (this.hasState(32)) {
            this.fireTextEditingEnded();
        }
        return false;
    }

    protected boolean mouseDoubleClicked(MouseEvent.MouseDoubleClickedEvent event) {
        if (event.button != 1) {
            return false;
        }
        if (this.isHovering()) {
            ICanvasContext ctx = DiagramNodeUtil.getCanvasContext((IG2DNode)this);
            if (ctx == null) {
                return false;
            }
            if (this.text != null) {
                this.setCaret(0, false);
                this.setCaret(this.text.length(), true);
                this.repaint();
            }
        }
        return false;
    }

    protected boolean mouseButtonPressed(MouseEvent.MouseButtonPressedEvent event) {
        if (!this.hasState(32)) {
            return false;
        }
        Point2D local = this.controlToLocal(event.controlPosition);
        local = this.parentToLocal(local);
        if (this.hasState(2) && this.containsLocal(local)) {
            this.setCaret(local, event.isShiftDown());
        }
        if (!this.isHovering()) {
            this.fireTextEditingEnded();
        }
        return false;
    }

    protected boolean mouseMoved(MouseEvent.MouseMovedEvent event) {
        boolean hit;
        if (!this.elementBasedFocus && (hit = this.hitTest((MouseEvent)event, 3.0)) != this.hasState(2)) {
            this.setState(2, hit);
            this.repaint();
        }
        return false;
    }

    public void setMouseOver(boolean mouseOver) {
        if (mouseOver != this.hasState(2)) {
            this.setState(2, mouseOver);
            this.repaint();
        }
    }

    private boolean isControlDown(MouseEvent e) {
        return e.isControlDown() || this.lastMouseEvent != null ? this.lastMouseEvent.isControlDown() : false;
    }

    protected boolean isShiftDown(MouseEvent e) {
        return e.isShiftDown() || this.lastMouseEvent != null ? this.lastMouseEvent.isShiftDown() : false;
    }

    protected boolean mouseDragged(MouseEvent.MouseDragBegin e) {
        this.dragged = true;
        if (this.isHovering() && (this.isControlDown((MouseEvent)e) || this.isShiftDown((MouseEvent)e)) && (this.dataRVI != null || this.text != null)) {
            ArrayList<Object> trs = new ArrayList<Object>(2);
            if (this.dataRVI != null) {
                trs.add(new LocalObjectTransferable((Object)this.dataRVI));
                trs.add(new PlaintextTransfer(this.dataRVI.toString()));
            } else if (this.text != null && !this.text.isEmpty()) {
                trs.add(new PlaintextTransfer(this.text));
            }
            if (!trs.isEmpty()) {
                e.transferable = new MultiTransferable(trs);
                return true;
            }
        }
        return false;
    }

    protected boolean hitTest(MouseEvent event, double tolerance) {
        Rectangle2D bounds = this.getBoundsInternal();
        if (bounds == null) {
            return false;
        }
        Point2D localPos = NodeUtil.worldToLocal((IG2DNode)this, (Point2D)event.controlPosition, (Point2D)new Point2D.Double());
        double x = localPos.getX();
        double y = localPos.getY();
        boolean hit = bounds.contains(x, y);
        return hit;
    }

    public Rectangle2D getBoundsInternal() {
        Rectangle2D local = this.lastBounds;
        if (local == null) {
            return null;
        }
        if (this.transform.isIdentity()) {
            return local;
        }
        return this.transform.createTransformedShape(local).getBounds2D();
    }

    protected Color add(Color c, int r, int g, int b) {
        int nr = Math.min(255, c.getRed() + r);
        int ng = Math.min(255, c.getGreen() + g);
        int nb = Math.min(255, c.getBlue() + b);
        return new Color(nr, ng, nb);
    }

    public TextEditActivation activateEdit(int mouseId, IElement e, ICanvasContext ctx) {
        EditDataNode data = EditDataNode.getNode((INode)this);
        this.deactivateEdit(data, null);
        TextEditActivation result = new TextEditActivation(mouseId, e, ctx);
        data.setTextEditActivation(result);
        this.setFocusNode((IG2DNode)this);
        return result;
    }

    protected boolean deactivateEdit() {
        boolean result = this.deactivateEdit(this.editActivation);
        boolean bl = this.editActivation != null;
        this.editActivation = null;
        this.setFocusNode(null);
        return result |= bl;
    }

    protected boolean deactivateEdit(TextEditActivation activation) {
        return this.deactivateEdit(EditDataNode.getNode((INode)this), activation);
    }

    protected boolean deactivateEdit(EditDataNode data, TextEditActivation activation) {
        TextEditActivation previous = data.getTextEditActivation();
        if (previous != null && (previous == activation || activation == null)) {
            previous.release();
            data.setTextEditActivation(null);
            return true;
        }
        return false;
    }

    public int getEventMask() {
        return EventTypes.KeyPressedMask | EventTypes.MouseMovedMask | EventTypes.MouseButtonPressedMask | EventTypes.MouseClickMask | EventTypes.MouseDragBeginMask | EventTypes.CommandMask;
    }

    public boolean handleEvent(Event e) {
        if (e instanceof MouseEvent && !(e instanceof MouseEvent.MouseDragBegin)) {
            this.lastMouseEvent = (MouseEvent)e;
        }
        return super.handleEvent(e);
    }

    public Function1<Object, Boolean> getPropertyFunction(String propertyName) {
        return G2DUtils.getMethodPropertyFunctionWithG2DRepaint((IThreadWorkQueue)AWTThread.getThreadAccess(), (IG2DNode)this, (String)propertyName);
    }

    public <T> T getProperty(String propertyName) {
        return null;
    }

    public void setPropertyCallback(Function2<String, Object, Boolean> callback) {
    }

    public void synchronizeText(String text) {
        this.setText(text);
    }

    public void synchronizeColor(RGB.Integer color) {
        this.color = Colors.awt((RGB.Integer)color);
    }

    public void synchronizeFont(Font font) {
        this.setFont(Fonts.awt((Font)font));
    }

    public void synchronizeTransform(double[] data) {
        this.setTransform(new AffineTransform(data));
    }

    public static void main(String[] args) {
        Object[] lines = TextNode.parseLines("\n  \n FOO  \n\nBAR\n\n\n BAZ\n\n");
        System.out.println(Arrays.toString(lines));
        System.out.println(GeometryUtils.pointToMillimeter((float)1.0f));
        System.out.println(GeometryUtils.pointToMillimeter((float)12.0f));
        System.out.println(GeometryUtils.pointToMillimeter((float)72.0f));
    }

    protected double getHorizontalAlignOffset(Rectangle2D r) {
        switch (this.horizontalAlignment) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return -r.getWidth();
            }
            case 2: {
                return -r.getCenterX();
            }
        }
        return 0.0;
    }

    protected double getVerticalAlignOffset() {
        FontMetrics fm = this.fontMetrics;
        if (fm == null) {
            return 0.0;
        }
        switch (this.verticalAlignment) {
            case 0: {
                return fm.getMaxAscent();
            }
            case 1: {
                return -fm.getMaxDescent();
            }
            case 2: {
                return fm.getMaxAscent() / 2;
            }
            case 3: {
                return 0.0;
            }
        }
        return 0.0;
    }

    public static enum TextFlipping {
        Disabled,
        VerticalTextUpwards,
        VerticalTextDownwards;

    }
}

