/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.elements;

import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.IEventHandler;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.nodes.NavigationNode;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;

public class ResizeNode
extends G2DNode {
    private static final long serialVersionUID = 7997312998598071328L;
    private boolean dragging = false;
    private ResizeListener resizeListener;
    private Rectangle2D bounds;
    private Stroke stroke;
    protected transient BasicStroke pickStroke;
    protected transient double previousPadding = Double.NaN;
    private TranslateEdge xTranslateEdge = TranslateEdge.WEST;
    private TranslateEdge YTranslateEdge = TranslateEdge.NORTH;
    int cursor = 0;
    double dragTolerance = 0.5;
    private static double minSize = 5.0;

    public ResizeNode() {
        this(1.0f);
    }

    public ResizeNode(float borderWidth) {
        this.stroke = new BasicStroke(borderWidth);
    }

    @INode.PropertySetter(value="Bounds")
    @INode.SyncField(value={"bounds"})
    public void setBounds(Rectangle2D bounds) {
        assert (bounds != null);
        this.bounds = bounds;
    }

    @INode.PropertySetter(value="stroke")
    @INode.SyncField(value={"stroke"})
    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public boolean dragging() {
        return this.dragging;
    }

    public void setResizeListener(ResizeListener listener) {
        this.resizeListener = listener;
    }

    public void cleanup() {
        this.removeEventHandler((IEventHandler)this);
        super.cleanup();
    }

    public void init() {
        super.init();
        this.addEventHandler((IEventHandler)this);
    }

    protected Shape getOutline() {
        double padding = this.calculatePickTolerance();
        if (this.pickStroke == null || padding != this.previousPadding) {
            this.pickStroke = new BasicStroke((float)(padding * 2.0));
            this.previousPadding = padding;
        }
        Shape s = this.pickStroke.createStrokedShape(new Rectangle2D.Double(this.bounds.getX() - padding, this.bounds.getY() - padding, this.bounds.getWidth() + padding * 2.0, this.bounds.getHeight() + padding * 2.0));
        return s;
    }

    protected boolean mouseButtonPressed(MouseEvent.MouseButtonPressedEvent event) {
        if (this.bounds != null && NodeUtil.isSelected((INode)this, (int)1)) {
            Point2D local = this.controlToLocal(event.controlPosition);
            local = this.parentToLocal(local);
            Shape outline = this.getOutline();
            if (outline.contains(local)) {
                this.dragging = true;
                return true;
            }
        }
        return super.mouseButtonPressed(event);
    }

    private double calculatePickTolerance() {
        NavigationNode nn = (NavigationNode)NodeUtil.findNearestParentNode((INode)this, NavigationNode.class);
        double scale = 1.0;
        if (nn != null) {
            scale = GeometryUtils.getScale((AffineTransform)nn.getTransform());
        }
        double pickDistance = 0.0;
        G2DSceneGraph sg = NodeUtil.getRootNode((IG2DNode)(nn != null ? nn : this));
        if (sg != null) {
            pickDistance = (Double)sg.getGlobalProperty("pickDistance", (Object)0.0);
        }
        return pickDistance > 0.0 ? pickDistance / scale : (double)(((BasicStroke)this.stroke).getLineWidth() / 2.0f);
    }

    private int getCursorDirection(Point2D local) {
        double tolerance = this.calculatePickTolerance();
        int cursor = 0;
        if (local.getX() >= this.bounds.getX() - tolerance * 2.0 && local.getX() <= this.bounds.getX()) {
            cursor = 10;
        } else if (local.getX() >= this.bounds.getMaxX() && local.getX() <= this.bounds.getMaxX() + tolerance * 2.0) {
            cursor = 11;
        }
        if (local.getY() >= this.bounds.getY() - tolerance * 2.0 && local.getY() <= this.bounds.getY()) {
            cursor = cursor == 10 ? 6 : (cursor == 11 ? 7 : 8);
        } else if (local.getY() >= this.bounds.getMaxY() && local.getY() <= this.bounds.getMaxY() + tolerance * 2.0) {
            cursor = cursor == 10 ? 4 : (cursor == 11 ? 5 : (cursor |= 9));
        }
        return cursor;
    }

    protected boolean mouseMoved(MouseEvent.MouseMovedEvent e) {
        if (this.dragging) {
            Point2D local = this.controlToLocal(e.controlPosition);
            local = this.parentToLocal(local);
            Rectangle2D bounds = this.getBoundsInLocal().getBounds2D();
            if (Math.abs(bounds.getMaxX() - local.getX()) > this.dragTolerance || Math.abs(bounds.getMaxY() - local.getY()) > this.dragTolerance) {
                this.resize(local, false);
            }
            return true;
        }
        if (NodeUtil.isSelected((INode)this, (int)1)) {
            Point2D local = this.controlToLocal(e.controlPosition);
            local = this.parentToLocal(local);
            Shape outline = this.getOutline();
            if (outline.contains(local)) {
                this.cursor = this.getCursorDirection(local);
                CanvasContext ctx = (CanvasContext)e.getContext();
                ctx.getMouseCursorContext().setCursor(e.mouseId, Cursor.getPredefinedCursor(this.cursor));
            } else if (this.cursor != 0) {
                this.cursor = 0;
                CanvasContext ctx = (CanvasContext)e.getContext();
                ctx.getMouseCursorContext().setCursor(e.mouseId, Cursor.getPredefinedCursor(0));
            }
        }
        return super.mouseMoved(e);
    }

    protected boolean mouseDragged(MouseEvent.MouseDragBegin e) {
        return this.dragging;
    }

    private void resize(Point2D local, boolean synchronize) {
        double dh;
        double dw;
        Rectangle2D bounds = this.getBoundsInLocal().getBounds2D();
        double x = bounds.getX();
        double y = bounds.getY();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        double dx = 0.0;
        double dy = 0.0;
        if (this.cursor == 10 || this.cursor == 6 || this.cursor == 4) {
            dw = local.getX() - x;
            if (w - dw < minSize) {
                dw = w - minSize;
            }
            w -= dw;
            if (TranslateEdge.WEST.equals((Object)this.xTranslateEdge)) {
                dx = dw;
            }
        }
        if (this.cursor == 8 || this.cursor == 6 || this.cursor == 7) {
            dh = local.getY() - y;
            if (h - dh < minSize) {
                dh = h - minSize;
            }
            h -= dh;
            if (TranslateEdge.NORTH.equals((Object)this.YTranslateEdge)) {
                dy = dh;
            }
        }
        if (this.cursor == 11 || this.cursor == 7 || this.cursor == 5) {
            dw = local.getX() - bounds.getMaxX();
            double d = w = w + dw > minSize ? w + dw : minSize;
            if (TranslateEdge.EAST.equals((Object)this.xTranslateEdge)) {
                dx = w - bounds.getWidth();
            }
        }
        if (this.cursor == 9 || this.cursor == 4 || this.cursor == 5) {
            dh = local.getY() - bounds.getMaxY();
            double d = h = h + dh > minSize ? h + dh : minSize;
            if (TranslateEdge.SOUTH.equals((Object)this.YTranslateEdge)) {
                dy = h - bounds.getHeight();
            }
        }
        this.bounds.setRect(x, y, w, h);
        AffineTransform at = new AffineTransform();
        at.translate(dx, dy);
        if (this.resizeListener != null) {
            this.resizeListener.elementResized(this.bounds, at, synchronize);
        }
    }

    protected boolean mouseButtonReleased(MouseEvent.MouseButtonReleasedEvent e) {
        if (this.dragging) {
            Point2D local = this.controlToLocal(e.controlPosition);
            local = this.parentToLocal(local);
            this.resize(local, true);
            this.dragging = false;
            CanvasContext ctx = (CanvasContext)e.getContext();
            this.cursor = 0;
            ctx.getMouseCursorContext().setCursor(e.mouseId, Cursor.getPredefinedCursor(this.cursor));
        }
        return super.mouseButtonReleased(e);
    }

    public int getEventMask() {
        return super.getEventMask() | EventTypes.MouseButtonPressedMask | EventTypes.MouseMovedMask | EventTypes.MouseButtonReleasedMask | EventTypes.MouseDragBeginMask;
    }

    public Rectangle2D getBoundsInLocal() {
        if (this.bounds == null) {
            return null;
        }
        return this.bounds.getBounds2D();
    }

    public void render(Graphics2D g2d) {
    }

    public void setxTranslateEdge(TranslateEdge xTranslateEdge) {
        this.xTranslateEdge = xTranslateEdge;
    }

    public void setYTranslateEdge(TranslateEdge yTranslateEdge) {
        this.YTranslateEdge = yTranslateEdge;
    }

    public static interface ResizeListener {
        public void elementResized(Rectangle2D var1, AffineTransform var2, boolean var3);
    }

    public static enum TranslateEdge {
        NONE,
        NORTH,
        SOUTH,
        EAST,
        WEST;

    }
}

