/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.elements;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;

class Line {
    public static BoundsProcedure BBOX = new BoundsProcedure(){

        @Override
        public Rectangle2D getBounds(Line line) {
            return line.bbox;
        }
    };
    public static BoundsProcedure ABBOX = new BoundsProcedure(){

        @Override
        public Rectangle2D getBounds(Line line) {
            return line.abbox;
        }
    };
    public final String document;
    public final int startOffset;
    public final int endOffset;
    float drawPosX;
    float drawPosY;
    float alignedPosX;
    float alignedPosY;
    TextLayout layout;
    Rectangle2D bbox;
    Rectangle2D abbox;

    public Line(String document, int startOffset, int endOffset) {
        int len = document.length();
        if (endOffset < startOffset) {
            throw new IllegalArgumentException("endOffset (" + endOffset + ") < startOffset (" + startOffset + ")");
        }
        if (startOffset < 0 || startOffset > len) {
            throw new IllegalArgumentException("startOffset " + startOffset + " out of bounds [0," + len + "]");
        }
        if (endOffset < 0 || endOffset > len) {
            throw new IllegalArgumentException("endOffset " + endOffset + " out of bounds [0," + len + "]");
        }
        this.document = document;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public void render(Graphics2D g) {
        if (this.layout != null) {
            this.layout.draw(g, this.alignedPosX, this.alignedPosY);
        }
    }

    public String getText() {
        return this.document.substring(this.startOffset, this.endOffset);
    }

    public boolean intersectsRange(int start, int end) {
        return start < this.endOffset && end > this.startOffset;
    }

    public boolean containsRange(int start, int end) {
        return start >= this.startOffset && start <= this.endOffset && end > this.startOffset && end <= this.endOffset;
    }

    public boolean containsOffset(int caret) {
        return this.startOffset <= caret && caret <= this.endOffset;
    }

    public Shape getLogicalHighlightShape(int start, int end) {
        return this.layout.getLogicalHighlightShape(Math.max(0, start - this.startOffset), Math.min(this.endOffset - this.startOffset, end - this.startOffset));
    }

    public Shape[] getCaretShapes(int caret) {
        return this.layout.getCaretShapes(caret - this.startOffset);
    }

    public void translate(Graphics2D g, float xOffset, float yOffset) {
        g.translate(this.alignedPosX + xOffset, this.alignedPosY + yOffset);
    }

    public void translateInv(Graphics2D g, float xOffset, float yOffset) {
        g.translate(-this.alignedPosX - xOffset, -this.alignedPosY - yOffset);
    }

    public void alignOffset(double x, double y) {
        this.alignedPosX = this.drawPosX + (float)x;
        this.alignedPosY = this.drawPosY + (float)y;
        if (this.abbox == null) {
            this.abbox = new Rectangle2D.Float();
        }
        this.abbox.setFrame(this.bbox.getX() + x, this.bbox.getY() + y, this.bbox.getWidth(), this.bbox.getHeight());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ", x=" + this.drawPosX + ", y=" + this.drawPosY + ", ax='" + this.alignedPosX + ", ay=" + this.alignedPosY + ", text='" + this.getText() + ", bbox='" + String.valueOf(this.bbox) + ", abbox=" + String.valueOf(this.abbox) + "']";
    }

    public static interface BoundsProcedure {
        public Rectangle2D getBounds(Line var1);
    }
}

