/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.content;

public class OrderedPair<T extends Comparable<T>> {
    private final T first;
    private final T second;

    public OrderedPair(T first, T second) {
        assert (first != null);
        assert (second != null);
        int comp = first.compareTo(second);
        if (comp < 0) {
            this.first = first;
            this.second = second;
        } else {
            this.first = second;
            this.second = first;
        }
    }

    public T first() {
        return this.first;
    }

    public T second() {
        return this.second;
    }

    public int hashCode() {
        return this.first.hashCode() * 31 + this.second.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OrderedPair)) {
            return false;
        }
        OrderedPair other = (OrderedPair)obj;
        return this.first.equals(other.first) && this.second.equals(other.second);
    }

    public static <T extends Comparable<T>> OrderedPair<T> make(T ra, T rb) {
        return new OrderedPair<T>(ra, rb);
    }
}

