/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.content;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.adapter.DiagramContentRequest;
import org.simantics.diagram.content.DiagramContentChanges;
import org.simantics.diagram.content.DiagramContents;
import org.simantics.diagram.synchronization.ErrorHandler;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.utils.ui.ErrorLogger;

public class DiagramContentTracker {
    private final ErrorHandler errorHandler = new ErrorHandler(){

        @Override
        public void warning(String message, Exception e) {
            ErrorLogger.defaultLogWarning((String)message, (Throwable)e);
        }

        @Override
        public void error(String message, Throwable t) {
            ErrorLogger.defaultLogError((String)message, (Throwable)t);
        }
    };
    private DiagramContents lastContents = new DiagramContents();
    private DiagramContentChanges lastDifference = DiagramContentChanges.EMPTY;
    private final ICanvasContext context;
    private final Session session;
    private final Resource diagram;

    public static DiagramContentTracker start(ICanvasContext context, RequestProcessor processor, Resource diagram) throws DatabaseException {
        DiagramContentTracker tracker = new DiagramContentTracker(context, processor.getSession(), diagram);
        tracker.update(processor);
        return tracker;
    }

    private DiagramContentTracker(ICanvasContext context, Session session, Resource diagram) {
        if (context == null) {
            throw new NullPointerException("null canvas context");
        }
        if (session == null) {
            throw new NullPointerException("null session");
        }
        if (diagram == null) {
            throw new NullPointerException("null diagram");
        }
        this.context = context;
        this.session = session;
        this.diagram = diagram;
    }

    public DiagramContentChanges update() throws DatabaseException {
        return this.update((RequestProcessor)this.session);
    }

    public DiagramContentChanges update(RequestProcessor processor) throws DatabaseException {
        DiagramContentChanges changes;
        DiagramContents contents = (DiagramContents)processor.syncRequest((Read)new DiagramContentRequest(this.context, this.diagram, this.errorHandler));
        this.lastDifference = changes = contents.differenceFrom(this.lastContents);
        this.lastContents = contents;
        return changes;
    }

    public DiagramContents getLastContents() {
        return this.lastContents;
    }

    public DiagramContentChanges getLastDifference() {
        return this.lastDifference;
    }
}

