/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.DefaultPasteHandler;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.request.Read;
import org.simantics.diagram.internal.Activator;
import org.simantics.graph.db.IImportAdvisor2;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.ontology.ScenegraphResources;

public class ScenegraphCompositePasteHandler
extends DefaultPasteHandler {
    int copied;

    public ScenegraphCompositePasteHandler(Resource resource) {
        super(resource);
    }

    public void onPasteBegin(WriteGraph graph) {
        this.copied = 0;
    }

    public void onPaste(WriteGraph graph, IImportAdvisor2 advisor, Set<SimanticsClipboard.Representation> representations) {
        final Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        final ScenegraphResources SG = ScenegraphResources.getInstance((ReadGraph)graph);
        try {
            final Resource parent = advisor.getTarget();
            if (parent == null) {
                return;
            }
            Collection roots = advisor.getRoots();
            if (roots == null || roots.isEmpty()) {
                return;
            }
            for (Resource root : roots) {
                if (graph.isInstanceOf(root, SG.Node)) continue;
                return;
            }
            Resource list = (Resource)graph.syncRequest((Read)new UniqueRead<Resource>(){

                public Resource perform(ReadGraph g) throws DatabaseException {
                    Resource res = g.getPossibleObject(parent, SG.Node_children);
                    return res == null || !g.isInstanceOf(res, L0.List) ? null : res;
                }
            });
            if (list == null) {
                return;
            }
            ListUtils.insertBack((WriteGraph)graph, (Resource)list, (Iterable)roots);
            this.copied += roots.size();
        }
        catch (DatabaseException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.diagram", "Failed to attach copied scene graph nodes to target composite node, see exception for details.", (Throwable)e));
        }
    }

    public void onPasteEnd(WriteGraph graph) {
        if (this.copied > 0) {
            try {
                CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                graph.addMetadata((Metadata)cm.add("Copy " + this.copied + " scene graph nodes."));
            }
            catch (DatabaseException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.diagram", "Failed to attach metadata to commit, see exception for details.", (Throwable)e));
            }
        }
    }
}

