/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.DoesNotContainValueException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.NoSingleResultException;
import org.simantics.db.exception.ServiceException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.svg.LineCap;
import org.simantics.g2d.svg.LineJoin;
import org.simantics.layer0.Layer0;
import org.simantics.utils.strings.format.MetricsFormat;

public class G2DUtils {
    public static final Float DEFAULT_DASH_OFFSET = Float.valueOf(0.0f);
    public static final Float DEFAULT_STROKE_WIDTH = Float.valueOf(1.0f);
    public static final Float DEFAULT_MITER_LIMIT = Float.valueOf(10.0f);

    public static Object getObject(ReadGraph g, Resource resource) throws ServiceException, NoSingleResultException, DoesNotContainValueException, ManyObjectsForFunctionalRelationException {
        G2DResource g2d = G2DResource.getInstance((ReadGraph)g);
        Set types = g.getTypes(resource);
        if (types.contains(g2d.Font)) {
            return G2DUtils.getFont(g, resource);
        }
        if (types.contains(g2d.Color)) {
            return G2DUtils.getColor(g, resource);
        }
        if (types.contains(g2d.Transform)) {
            return G2DUtils.getTransform(g, resource);
        }
        if (types.contains(g2d.Rectangle2D)) {
            return G2DUtils.getRectangle(g, resource);
        }
        return g.getPossibleValue(resource);
    }

    public static Font getFont(ReadGraph g, Resource fontResource) throws ServiceException, NoSingleResultException, DoesNotContainValueException, ManyObjectsForFunctionalRelationException {
        G2DResource g2d = G2DResource.getInstance((ReadGraph)g);
        if (!g.isInstanceOf(fontResource, g2d.Font)) {
            throw new IllegalArgumentException("Resource " + String.valueOf(fontResource) + " is not a font");
        }
        String name = (String)g.getRelatedValue(fontResource, g2d.HasFontFamily);
        int size = (Integer)g.getRelatedValue(fontResource, g2d.HasFontSize);
        int style = 0;
        Resource styleResource = g.getPossibleObject(fontResource, g2d.HasFontStyle);
        if (styleResource != null) {
            if (styleResource.equals(g2d.FontStyle_bold_italic_style)) {
                style = 3;
            } else if (styleResource.equals(g2d.FontStyle_bold_font_style)) {
                style = 1;
            } else if (styleResource.equals(g2d.FontStyle_italic_font_style)) {
                style = 2;
            } else if (styleResource.equals(g2d.FontStyle_normal_font_style)) {
                style = 0;
            } else {
                throw new IllegalArgumentException("Given font " + String.valueOf(fontResource) + " does not contain valid style. Current style is " + String.valueOf(styleResource));
            }
        }
        return new Font(name, style, size);
    }

    public static Color getColor(ReadGraph g, Resource colorResource) throws DoesNotContainValueException, ServiceException {
        G2DResource g2d = G2DResource.getInstance((ReadGraph)g);
        if (!g.isInstanceOf(colorResource, g2d.Color)) {
            throw new IllegalArgumentException("Resource " + String.valueOf(colorResource) + " is not a color");
        }
        float[] value = (float[])g.getValue(colorResource);
        if (value.length != 4) {
            throw new IllegalArgumentException("Color " + String.valueOf(colorResource) + " does not have proper definition, expected 4 components, got " + value.length + " components");
        }
        return new Color(value[0], value[1], value[2], value[3]);
    }

    public static AffineTransform getTransform(ReadGraph g, Resource resource) throws DoesNotContainValueException, ServiceException {
        G2DResource g2d = G2DResource.getInstance((ReadGraph)g);
        if (!g.isInstanceOf(resource, g2d.Transform)) {
            throw new IllegalArgumentException("Resource " + String.valueOf(resource) + " is not a transform");
        }
        double[] values = (double[])g.getValue(resource);
        if (values.length != 6) {
            throw new IllegalArgumentException("Transform " + String.valueOf(resource) + " does not have proper definition, expected 6 components, got " + values.length + " components");
        }
        return new AffineTransform(values);
    }

    public static Rectangle2D getRectangle(ReadGraph g, Resource resource) throws DoesNotContainValueException, ServiceException {
        G2DResource g2d = G2DResource.getInstance((ReadGraph)g);
        if (!g.isInstanceOf(resource, g2d.Rectangle2D)) {
            throw new IllegalArgumentException("Resource " + String.valueOf(resource) + " is not a rectangle");
        }
        double[] values = (double[])g.getValue(resource);
        if (values.length != 4) {
            throw new IllegalArgumentException("Transform " + String.valueOf(resource) + " does not have proper definition, expected 4 components, got " + values.length + " components");
        }
        return new Rectangle2D.Double(values[0], values[1], values[2], values[3]);
    }

    public static Resource createFont(WriteGraph g, Font font) throws ServiceException, ManyObjectsForFunctionalRelationException {
        Layer0 b = Layer0.getInstance((ReadGraph)g);
        G2DResource g2d = G2DResource.getInstance((ReadGraph)g);
        Resource fontResource = g.newResource();
        g.claim(fontResource, b.InstanceOf, null, g2d.Font);
        g.claimLiteral(fontResource, g2d.HasFontFamily, (Object)font.getFamily());
        g.claimLiteral(fontResource, g2d.HasFontSize, (Object)font.getSize());
        if (font.getStyle() == 3) {
            g.claim(fontResource, g2d.HasFontStyle, g2d.FontStyle_bold_italic_style);
        } else if (font.getStyle() == 1) {
            g.claim(fontResource, g2d.HasFontStyle, g2d.FontStyle_bold_font_style);
        } else if (font.getStyle() == 2) {
            g.claim(fontResource, g2d.HasFontStyle, g2d.FontStyle_italic_font_style);
        } else {
            g.claim(fontResource, g2d.HasFontStyle, g2d.FontStyle_normal_font_style);
        }
        return fontResource;
    }

    public static Resource createColor(WriteGraph g, Color color) throws ServiceException {
        Layer0 b = Layer0.getInstance((ReadGraph)g);
        G2DResource g2d = G2DResource.getInstance((ReadGraph)g);
        Resource colorResource = g.newResource();
        g.claim(colorResource, b.InstanceOf, null, g2d.Color);
        g.claimValue(colorResource, (Object)color.getRGBComponents(null));
        return colorResource;
    }

    public static Resource createMetricsFormat(WriteGraph g, MetricsFormat format) throws ServiceException, ManyObjectsForFunctionalRelationException {
        Layer0 b = Layer0.getInstance((ReadGraph)g);
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
        Resource formatResource = g.newResource();
        g.claim(formatResource, b.InstanceOf, null, dr.Format);
        g.claimLiteral(formatResource, b.HasName, (Object)format.getName());
        g.claimLiteral(formatResource, dr.HasPattern, (Object)format.getPattern());
        return formatResource;
    }

    public static MetricsFormat getMetricsFormat(ReadGraph g, Resource formatResource) throws NoSingleResultException, DoesNotContainValueException, ServiceException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)g);
        String name = (String)g.getRelatedValue(formatResource, l0.HasName);
        String pattern = (String)g.getRelatedValue(formatResource, dr.HasPattern);
        return new MetricsFormat(pattern, 1.0, name);
    }

    public static BasicStroke getStroke(ReadGraph graph, Resource stroke) throws DatabaseException {
        return G2DUtils.getStroke(graph, stroke, DEFAULT_DASH_OFFSET, DEFAULT_STROKE_WIDTH, DEFAULT_MITER_LIMIT);
    }

    public static BasicStroke getStroke(ReadGraph graph, Resource stroke, Float defaultDashOffset, Float defaultStrokeWidth, Float defaultMiterLimit) throws DatabaseException {
        if (stroke == null) {
            return null;
        }
        G2DResource g2d = G2DResource.getInstance((ReadGraph)graph);
        float[] dashArray = DiagramGraphUtil.getPossibleRelatedValue(graph, stroke, g2d.HasDashArray, float[].class, null);
        Float dashOffset = DiagramGraphUtil.getPossibleRelatedValue(graph, stroke, g2d.HasDashOffset, Float.class, defaultDashOffset);
        Float strokeWidth = DiagramGraphUtil.getPossibleRelatedValue(graph, stroke, g2d.HasStrokeWidth, Float.class, defaultStrokeWidth);
        Float miterLimit = DiagramGraphUtil.getPossibleRelatedValue(graph, stroke, g2d.HasMiterLimit, Float.class, defaultMiterLimit);
        LineJoin lineJoin = DiagramGraphUtil.toLineJoin(g2d, graph.getPossibleObject(stroke, g2d.HasLineJoin));
        LineCap lineCap = DiagramGraphUtil.toLineCap(g2d, graph.getPossibleObject(stroke, g2d.HasLineCap));
        if (strokeWidth.floatValue() < 0.0f) {
            strokeWidth = Float.valueOf(0.0f);
        }
        return new BasicStroke(strokeWidth.floatValue(), lineCap.ordinal(), lineJoin.ordinal(), miterLimit.floatValue(), dashArray, dashOffset.floatValue());
    }

    public static Resource createStroke(WriteGraph graph, BasicStroke stroke) throws DatabaseException {
        if (stroke == null) {
            return null;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        G2DResource g2d = G2DResource.getInstance((ReadGraph)graph);
        Resource result = graph.newResource();
        graph.claim(result, L0.InstanceOf, null, g2d.Stroke);
        if (stroke.getDashArray() != null) {
            graph.claimLiteral(result, g2d.HasDashArray, L0.FloatArray, (Object)stroke.getDashArray(), (Binding)Bindings.FLOAT_ARRAY);
        }
        graph.claimLiteral(result, g2d.HasDashOffset, L0.Float, (Object)Float.valueOf(stroke.getDashPhase()), (Binding)Bindings.FLOAT);
        graph.claimLiteral(result, g2d.HasStrokeWidth, L0.Float, (Object)Float.valueOf(stroke.getLineWidth()), (Binding)Bindings.FLOAT);
        graph.claimLiteral(result, g2d.HasMiterLimit, L0.Float, (Object)Float.valueOf(stroke.getMiterLimit()), (Binding)Bindings.FLOAT);
        graph.claim(result, g2d.HasLineJoin, null, DiagramGraphUtil.toLineJoin(g2d, LineJoin.values()[stroke.getLineJoin()]));
        graph.claim(result, g2d.HasLineCap, null, DiagramGraphUtil.toLineCap(g2d, LineCap.values()[stroke.getEndCap()]));
        return result;
    }
}

