/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization.graph;

import java.awt.Color;

import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.diagram.synchronization.IModificationQueue;
import org.simantics.diagram.synchronization.ISynchronizationContext;
import org.simantics.g2d.element.ElementHints;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.datastructures.hints.IHintContext.Key;

/**
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 */
public class TextColorSynchronizer extends ResourceSynchronizer {

    public static final TextColorSynchronizer INSTANCE = new TextColorSynchronizer();

    private static final Key[] SYNCHRONIZED_HINTS = {
        ElementHints.KEY_TEXT_COLOR
    };

    @Override
    public Key[] getSynchronizedHints() {
        return SYNCHRONIZED_HINTS;
    }

    @Override
    public boolean hintChanged(ISynchronizationContext context, IModificationQueue queue, Resource object, IHintObservable sender, Key key, Object oldValue, Object newValue) {
        if (ElementHints.KEY_TEXT_COLOR.equals(key)) {
            BasicResources br = context.get(GraphSynchronizationHints.BASIC_RESOURCES);
            Color color = (Color)newValue;
            float array[] = color.getRGBComponents(null);
            return queue.offer(new PropertyModification(object, br.G2D.HasColor, br.G2D.Color, array, Bindings.FLOAT_ARRAY), null);
        }
        return false;
    }

}
