/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization.graph;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.diagram.synchronization.ModificationAdapter;

/**
 * @author Tuukka Lehtonen
 */
public class TagChange extends ModificationAdapter {

    final Resource object;
    final Resource tag;
    final boolean  set;

    public TagChange(Resource object, Resource tag, boolean set) {
        super(LOW_PRIORITY);
        this.object = object;
        this.tag = tag;
        this.set = set;
    }

    @Override
    public void perform(WriteGraph g) throws Exception {
        DiagramGraphUtil.tag(g, object, tag, set);
    }

}
