/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization.graph;

import org.simantics.databoard.binding.Binding;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.synchronization.ModificationAdapter;

/**
 * @author Tuukka Lehtonen
 */
public class RelatedPropertyModification extends ModificationAdapter {
    private final Resource subject;
    private final Resource relation;
    private final Resource propertyRelation;
    private final Resource type;
    private final Object value;
    private final Binding binding;

    public RelatedPropertyModification(Resource subject, Resource relation, Resource propertyRelation, Resource propertyType, Object value, Binding binding) {
        super(LOW_PRIORITY);
        this.subject = subject;
        this.relation = relation;
        this.propertyRelation = propertyRelation;
        this.type = propertyType;
        this.value = value;
        this.binding = binding;
    }

    @Override
    public void perform(WriteGraph g) throws DatabaseException {
        Resource propertyOwner = g.getPossibleObject(subject, relation);
        if (propertyOwner != null) {
        	Object existing = g.getPossibleRelatedValue(propertyOwner, propertyRelation, binding);
        	if(!value.equals(existing)) {
            	g.markUndoPoint();
        		DiagramGraphUtil.setRelatedValue(g, propertyOwner, propertyRelation, type, value, binding);
        		// Add comment to change set.
        		CommentMetadata cm = g.getMetadata(CommentMetadata.class);
        		g.addMetadata(cm.add("Changed property " + NameUtils.getSafeLabel(g, propertyRelation) + " in " + NameUtils.getSafeName(g, propertyOwner)));
        	}
        }
    }
    
}