/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization.graph;

import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.diagram.elements.MonitorClass;
import org.simantics.diagram.synchronization.IModificationQueue;
import org.simantics.diagram.synchronization.ISynchronizationContext;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintObservable;

/**
 * @author Tuukka Lehtonen
 */
public class MonitorSynchronizer extends ResourceSynchronizer {

    public static final MonitorSynchronizer INSTANCE = new MonitorSynchronizer();

    private static final Key[] SYNCHRONIZED_HINTS = {
        MonitorClass.KEY_DIRECTION,
    };

    @Override
    public Key[] getSynchronizedHints() {
        return SYNCHRONIZED_HINTS;
    }

    @Override
    public boolean hintChanged(ISynchronizationContext context, IModificationQueue queue, Resource object, IHintObservable sender, Key key, Object oldValue, Object newValue) {
        if (MonitorClass.KEY_DIRECTION.equals(key)) {
            BasicResources br = context.get(GraphSynchronizationHints.BASIC_RESOURCES);
            Double dir = (Double) newValue;
            queue.offer(new PropertyModification(object, br.DIA.HasDirection, br.L0.Double, dir, Bindings.DOUBLE), null);
            return true;
        }

        return false;
    }

}
