/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization.graph;

import java.util.Map;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.synchronization.CopyAdvisor;
import org.simantics.diagram.synchronization.ISynchronizationContext;
import org.simantics.diagram.synchronization.SynchronizationException;

/**
 * @author Tuukka Lehtonen
 */
public abstract class GraphCopyAdvisor implements CopyAdvisor {

    @Override
    public final Evaluation canCopy(ISynchronizationContext context, Object source, Object sourceContainer, Object targetContainer) {
        if (!(source instanceof Resource))
            return Evaluation.NOT_SUPPORTED;
        
//        if (!(sourceContainer instanceof Resource))
//            return Evaluation.NOT_SUPPORTED;
//        if (!(targetContainer instanceof Resource))
//            return Evaluation.NOT_SUPPORTED;

        Resource resource = (Resource) source;
        Resource sourceCont = (Resource) sourceContainer;
        Resource targetCont = (Resource) targetContainer;

        WriteGraph graph = context.get(GraphSynchronizationHints.WRITE_TRANSACTION);
        if (graph == null)
            return Evaluation.NOT_SUPPORTED;

        try {
            return canCopy(context, graph, resource, sourceCont, targetCont);
        } catch (DatabaseException e) {
            Logger.defaultLogError(e);
            return Evaluation.NOT_SUPPORTED;
        }
    }

    @Override
    public final Object copy(ISynchronizationContext context, Object source, Object sourceContainer, Object targetContainer) {
    	
        if (!(source instanceof Resource))
            return null;
        
//        if (!(sourceContainer instanceof Resource))
//            return null;
//        if (!(targetContainer instanceof Resource))
//            return null;

        Resource resource = (Resource) source;
        Resource sourceCont = (Resource) sourceContainer;
        Resource targetCont = (Resource) targetContainer;

        WriteGraph graph = context.get(GraphSynchronizationHints.WRITE_TRANSACTION);
        if (graph == null)
            throw new SynchronizationException("no write transaction");
        try {
            return copy(context, graph, resource, sourceCont, targetCont);
        } catch (DatabaseException e) {
            throw new SynchronizationException(e);
        }
    }

    @Override
    public final Object copy(ISynchronizationContext context, Object source, Object sourceContainer, Object targetContainer, Map<Object, Object> map) {

        if (!(source instanceof Resource))
            return null;
        
//        if (!(sourceContainer instanceof Resource))
//            return null;
//        if (!(targetContainer instanceof Resource))
//            return null;

        Resource resource = (Resource) source;
        Resource sourceCont = (Resource) sourceContainer;
        Resource targetCont = (Resource) targetContainer;

        WriteGraph graph = context.get(GraphSynchronizationHints.WRITE_TRANSACTION);
        if (graph == null)
            throw new SynchronizationException("no write transaction");
        try {
            return copy(context, graph, resource, sourceCont, targetCont, map);
        } catch (DatabaseException e) {
            throw new SynchronizationException(e);
        }
    }

    @Override
    public final Object cut(ISynchronizationContext context, Object source, Object sourceContainer, Object targetContainer) {
    	
        if (!(source instanceof Resource))
            return null;
        
//        if (!(sourceContainer instanceof Resource))
//            return null;
//        if (!(targetContainer instanceof Resource))
//            return null;

        Resource resource = (Resource) source;
        Resource sourceCont = (Resource) sourceContainer;
        Resource targetCont = (Resource) targetContainer;

        WriteGraph graph = context.get(GraphSynchronizationHints.WRITE_TRANSACTION);
        if (graph == null)
            throw new SynchronizationException("no write transaction");

        try {
            return cut(context, graph, resource, sourceCont, targetCont);
        } catch (DatabaseException e) {
            throw new SynchronizationException(e);
        }
    }

    @Override
    public void onFinish(ISynchronizationContext context) {

    	WriteGraph graph = context.get(GraphSynchronizationHints.WRITE_TRANSACTION);
        if (graph == null)
            throw new SynchronizationException("no write transaction");
        
        try {
			onFinish(context, graph);
        } catch (DatabaseException e) {
            throw new SynchronizationException(e);
        }
    	
    }
    
    public void onFinish(ISynchronizationContext context, WriteGraph graph) throws DatabaseException {
    	
    }

    public abstract Evaluation canCopy(ISynchronizationContext context, WriteGraph graph, Resource source,
            Resource sourceContainer, Resource targetContainer) throws DatabaseException;

    public abstract Object copy(ISynchronizationContext context, WriteGraph graph, Resource source,
            Resource sourceContainer, Resource targetContainer) throws DatabaseException;

    public abstract Object copy(ISynchronizationContext context, WriteGraph graph, Resource source,
            Resource sourceContainer, Resource targetContainer, Map<Object, Object> map) throws DatabaseException;

    public abstract Object cut(ISynchronizationContext context, WriteGraph graph, Resource source,
            Resource sourceContainer, Resource targetContainer) throws DatabaseException;
    
}
