/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization.graph;

import java.util.Map;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.synchronization.CopyAdvisor;
import org.simantics.diagram.synchronization.ISynchronizationContext;
import org.simantics.layer0.utils.direct.GraphUtils.ResourceTester;

/**
 * @author Tuukka Lehtonen
 */
public class AssociativeCopyAdvisor extends GraphCopyAdvisor {

    Map<ResourceTester, CopyAdvisor> advisors;

    public AssociativeCopyAdvisor(Map<ResourceTester, CopyAdvisor> advisors) {
        this.advisors = advisors;
    }

    @Override
    public Evaluation canCopy(ISynchronizationContext context, WriteGraph graph, Resource source,
            Resource sourceContainer, Resource targetContainer) throws DatabaseException {
        for (Map.Entry<ResourceTester, CopyAdvisor> entry : advisors.entrySet()) {
            if (!entry.getKey().test(graph, source))
                continue;
            Evaluation eval = entry.getValue().canCopy(context, source, sourceContainer, targetContainer);
            if (eval == Evaluation.SUPPORTED)
                return eval;
        }
        return Evaluation.NOT_SUPPORTED;
    }

    @Override
    public Object copy(ISynchronizationContext context, WriteGraph graph, Resource source, Resource sourceContainer,
            Resource targetContainer) throws DatabaseException {
        for (Map.Entry<ResourceTester, CopyAdvisor> entry : advisors.entrySet()) {
            if (!entry.getKey().test(graph, source))
                continue;
            Object copy = entry.getValue().copy(context, source, sourceContainer, targetContainer);
            if (copy != null)
                return copy;
        }
        return null;
    }

    @Override
    public Object copy(ISynchronizationContext context, WriteGraph graph, Resource source, Resource sourceContainer,
            Resource targetContainer, Map<Object, Object> map) throws DatabaseException {
        for (Map.Entry<ResourceTester, CopyAdvisor> entry : advisors.entrySet()) {
            if (!entry.getKey().test(graph, source))
                continue;
            Object copy = entry.getValue().copy(context, source, sourceContainer, targetContainer, map);
            if (copy != null)
                return copy;
        }
        return null;
    }

    @Override
    public Object cut(ISynchronizationContext context, WriteGraph graph, Resource source, Resource sourceContainer,
            Resource targetContainer) throws DatabaseException {
        for (Map.Entry<ResourceTester, CopyAdvisor> entry : advisors.entrySet()) {
            if (!entry.getKey().test(graph, source))
                continue;
            Object cut = entry.getValue().cut(context, source, sourceContainer, targetContainer);
            if (cut != null)
                return cut;
        }
        return null;
    }

}
