/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization;

import org.simantics.db.WriteGraph;

/**
 * @author Tuukka Lehtonen
 */
public class ModificationAdapter implements IModification {

    public static final Double HIGH_PRIORITY                = 1d;

    public static final Double REMOVE_EDGE_PRIORITY         = 2d;
    public static final Double REMOVE_BRANCH_PRIORITY       = 3d;
    public static final Double REMOVE_CONNECTION_PRIORITY   = 4d;
    public static final Double REMOVE_NODE_PRIORITY         = 5d;

    public static final Double ADD_NODE_PRIORITY            = 6d;
    public static final Double ADD_CONNECTION_PRIORITY      = 7d;
    public static final Double ADD_BRANCH_PRIORITY          = 8d;
    public static final Double ADD_EDGE_PRIORITY            = 9d;
    public static final Double SET_CONNECTION_TYPE_PRIORITY = 9.5d;

    public static final Double LOW_PRIORITY                 = 10d;

    final Double priority;

    Throwable exception;
    boolean complete = false;
    protected ModificationAdapter(Double priority) {
        assert priority != null;
        this.priority = priority;
    }
    @Override
    public boolean isComplete() {
        return complete;
    }
    @Override
    public void markComplete() {
        this.complete = true;
    }
    @Override
    public void perform(WriteGraph g) throws Exception {
    }
    @Override
    public void completed() {
    }
    @Override
    public Throwable getException() {
        return exception;
    }
    @Override
    public void setException(Throwable t) {
        this.exception = t;
    }
    //@Override
    //public String toString() {
    //    return getClass().getSimpleName();
    //}
    @Override
    public Double getPriority() {
        return priority;
    }
    @Override
    public int compareTo(IModification arg0) {
        return priority.compareTo(arg0.getPriority());
    }
    @Override
    public String toString() {
        return getClass().getSimpleName() + "$" + System.identityHashCode(this);
    }
}