/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization;

import java.util.Collection;

import org.simantics.db.WriteGraph;

/**
 * @author Tuukka Lehtonen
 */
public class CompositeModification extends ModificationAdapter {

    private final Collection<IModification> modifications;

    public CompositeModification(Double priority, Collection<IModification> modifications) {
        super(priority);
        this.modifications = modifications;
    }

    @Override
    public void perform(WriteGraph g) throws Exception {
        for (IModification m : modifications) {
            m.perform(g);
            m.markComplete();
        }
    }

    @Override
    public void completed() {
        for (IModification m : modifications) {
            m.completed();
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append('(');
        sb.append(modifications.size());
        sb.append(')');
        sb.append(modifications);
        return sb.toString();
    }

}
