/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.symbollibrary;

import org.eclipse.core.runtime.IAdaptable;
import org.simantics.db.procedure.Listener;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.handler.StaticSymbol;
import org.simantics.utils.datastructures.cache.ProvisionException;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;
import org.simantics.utils.datastructures.hints.IHintObservable;

/**
 * Represents a single symbol group element.
 * 
 * <p>
 * Implementations must override equals/hashCode.
 * </p>
 * 
 * @author Tuukka Lehtonen
 */
public interface ISymbolItem extends IAdaptable {

    /**
     * @return get the symbol group which this symbol item is a part of
     */
    ISymbolGroup getGroup();

    /**
     * @return the name of this symbol item to be shown to the user
     */
    String getName();

    /**
     * @return a more verbose description of the item, for tooltips etc.
     */
    String getDescription();

    /**
     * @param hints external hints for element class loading or
     *        <code>null</code> if no hints need to be provided
     * @return an {@link ElementClass} that must contain at least a
     *         {@link StaticSymbol} handler
     * @throws ProvisionException if the {@link ElementClass} cannot be
     *         retrieved for some reason
     */
    ElementClass getElementClass(IHintObservable hints) throws ProvisionException;

    /**
     * Pass a database listener in {@link #getElementClass(IHintObservable)}
     * hint observable argument using this key to start listening to the changes
     * in the element class result.
     */
    public static final Key KEY_ELEMENT_CLASS_LISTENER = new KeyOf(Listener.class, "ELEMENT_CLASS_LISTENER");

}
