/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.symbolcontribution;

import java.util.Arrays;

import org.simantics.diagram.symbollibrary.ISymbolGroup;
import org.simantics.diagram.symbollibrary.ISymbolItem;

/**
 * @author Tuukka Lehtonen
 */
public class SymbolGroup extends NamedObject implements ISymbolGroup {

    public static final ISymbolItem[] NO_ITEMS = {};

    ISymbolItem[] items = NO_ITEMS;

    private final String description;

    public SymbolGroup(Object identification, String name) {
        this(identification, name, name);
    }

    public SymbolGroup(Object identification, String name, ISymbolItem[] items) {
        this(identification, name, name, items);
    }

    public SymbolGroup(Object identification, String name, String description) {
        super(identification, name);
        this.description = description;
    }

    public SymbolGroup(Object identification, String name, String description, ISymbolItem[] items) {
        super(identification, name);
        this.description = description;
        this.items = items;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public ISymbolItem[] getItems() {
        return items;
    }

    public void setItems(ISymbolItem[] items) {
        this.items = items;
    }

    @Override
    public String toString() {
        return super.toString() + "[item count=" + items.length + "]";
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = super.hashCode();
        result = prime * result + ((description == null) ? 0 : description.hashCode());
        result = prime * result + Arrays.hashCode(items);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (!super.equals(obj))
            return false;
        if (getClass() != obj.getClass())
            return false;
        SymbolGroup other = (SymbolGroup) obj;
        if (description == null) {
            if (other.description != null)
                return false;
        } else if (!description.equals(other.description))
            return false;
        if (!Arrays.equals(items, other.items))
            return false;
        return true;
    }

}