/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.symbolcontribution;

import org.simantics.diagram.symbollibrary.IModifiableSymbolGroup;
import org.simantics.diagram.symbollibrary.ISymbolGroupListener;
import org.simantics.utils.datastructures.ListenerList;

/**
 * @author Tuukka Lehtonen
 */
public class ModifiableSymbolGroup extends SymbolGroup implements IModifiableSymbolGroup {

    ListenerList<ISymbolGroupListener> listeners = new ListenerList<ISymbolGroupListener>(ISymbolGroupListener.class);

    public ModifiableSymbolGroup(Object identification, String name) {
        super(identification, name);
    }

    public ModifiableSymbolGroup(Object identification, String name, String description) {
        super(identification, name, description);
    }

    @Override
    public void addListener(ISymbolGroupListener listener) {
        listeners.add(listener);
    }

    @Override
    public void removeListener(ISymbolGroupListener listener) {
        listeners.remove(listener);
    }

    protected void fireListeners() {
        for (ISymbolGroupListener listener : listeners.getListeners()) {
            listener.itemsChanged(this);
        }
    }

    @Override
    public String toString() {
        return super.toString() + "[listener count=" + listeners.size() + "]";
    }

}
