/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.symbolcontribution;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.simantics.diagram.symbollibrary.ISymbolGroup;

public abstract class AbstractSymbolProvider implements ISymbolProvider {
    protected volatile boolean         disposed = false;
    protected Runnable                 listener;
    protected Collection<ISymbolGroup> groups   = Collections.emptyList();
    private Set<ISymbolGroup>          groupSet = null;

    public Collection<ISymbolGroup> getSymbolGroups() {
        return groups;
    }

    public void setListener(Runnable listener) {
        this.listener = listener;
    }

    public void dispose() {
        disposed = true;
    }

    void setSymbolGroup(Collection<ISymbolGroup> groups) {
        if (groups == null)
            throw new NullPointerException("null groups");
        this.groups = groups;
    }

    protected Set<ISymbolGroup> getSymbolGroupSet() {
        synchronized (this) {
            if (groupSet != null)
                return groupSet;
            groupSet = new HashSet<ISymbolGroup>(getSymbolGroups());
            return groupSet;
        }
    }

    void lockGroups() {
        groups = Collections.unmodifiableCollection(groups);
        groupSet = null;
        getSymbolGroupSet();
    }

    @Override
    public int hashCode() {
        return getSymbolGroupSet().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof AbstractSymbolProvider))
            return false;
        AbstractSymbolProvider other = (AbstractSymbolProvider) obj;
        return getSymbolGroupSet().equals( other.getSymbolGroupSet() );
    }

}
