/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.template2d.ontology.Template2dResource;

/**
 * @author Tuukka Lehtonen
 */
public class FlagTypeFilters extends ResourceRead<List<FlagTypeFilter>> {

    public FlagTypeFilters(Resource visual) {
        super(visual);
    }

    @Override
    public List<FlagTypeFilter> perform(ReadGraph g) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(g);
        Template2dResource TEMPLATE2D = Template2dResource.getInstance(g);

        Collection<Resource> filters = g.syncRequest(new ObjectsWithType(resource, L0.ConsistsOf, TEMPLATE2D.FlagTypeVisual_Filter));
        if (filters.isEmpty())
            return Collections.emptyList();

        List<FlagTypeFilter> result = new ArrayList<FlagTypeFilter>(filters.size());
        for (Resource node : filters) {
            String reference = g.getPossibleRelatedValue2(node, TEMPLATE2D.FlagTypeVisual_Filter_HasProperty, Bindings.STRING);
            String pattern = g.getPossibleRelatedValue2(node, TEMPLATE2D.FlagTypeVisual_Filter_HasPattern, Bindings.STRING);
            Boolean matchRequired = g.getPossibleRelatedValue2(node, TEMPLATE2D.FlagTypeVisual_Filter_matchRequired, Bindings.BOOLEAN);
            result.add( new FlagTypeFilter(node, reference, pattern, matchRequired) );
        }
        return result;
    }

}
