package org.simantics.diagram.profile;

import java.util.ArrayList;
import java.util.List;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.diagram.synchronization.graph.BasicResources;

/**
 * @author Tuukka Lehtonen
 * @since 1.32.0
 */
public class TopLevelProfiles extends ResourceRead<List<NamedResource>> {

	protected TopLevelProfiles(Resource root) {
		super(root);
	}

	@Override
	public List<NamedResource> perform(ReadGraph graph) throws DatabaseException {
		BasicResources BR = BasicResources.getInstance(graph);
		ArrayList<NamedResource> result = new ArrayList<>();

		Instances query = graph.adapt(BR.DIA.Profile, Instances.class);
		for (Resource profile : query.find(graph, resource)) {
			if (!graph.hasStatement(profile, BR.L0.Abstract)) {
				String name = graph.getPossibleRelatedValue(profile, BR.L0.HasName, Bindings.STRING);
				if (name != null) {
					result.add(new NamedResource(name, profile));
				}
			}
		}

		return result;
	}

}
