package org.simantics.diagram.profile;

import java.awt.geom.AffineTransform;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;
import org.simantics.datatypes.literal.RGB;
import org.simantics.datatypes.literal.Vec2d;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.utils.datastructures.map.Tuple;

public class IconResult extends Tuple implements IconButtonResult {
	
    public static class B extends Bean implements IconButtonConfiguration {
    	private static final Binding BINDING = Bindings.getBindingUnchecked(B.class);
    	public String id;
    	public String iconName;
    	public int index;
    	public double loValue;
    	public double hiValue;
    	@Optional
    	public RGB.Integer loColor;
    	@Optional
    	public RGB.Integer midColor;
    	@Optional
    	public RGB.Integer hiColor;
    	@Optional
    	public Vec2d offset;
    	public Vec2d size;
    	public boolean relativeTransform;
    	public B(String id, String iconName, int index, double loValue, double hiValue, RGB.Integer loColor, RGB.Integer midColor, RGB.Integer hiColor, Vec2d offset, Vec2d size, boolean relativeTransform) {
    		super(BINDING);
    		this.id = id;
    		this.iconName = iconName;
    		this.index = index;
    		this.loValue = loValue;
    		this.hiValue = hiValue;
    		this.loColor = loColor;
    		this.midColor = midColor;
    		this.hiColor = hiColor;
    		this.offset = offset;
    		this.size = size;
    		this.relativeTransform = relativeTransform;
    	}
		@Override
		public Vec2d getOffset() {
			return offset;
		}
		@Override
		public String getId() {
			return id;
		}
		@Override
		public Vec2d getSize() {
			return size;
		}
		@Override
		public int getIndex() {
			return index;
		}
		@Override
		public boolean getRelativeTransform() {
			return relativeTransform;
		}
    }
    public static class A extends Bean implements IconButtonState {
    	private static final Binding BINDING = Bindings.getBindingUnchecked(A.class);
    	public double value;
    	public B config;
    	public A(double value, B config) {
    		super(BINDING);
    		this.value = value;
    		this.config = config;
    	}
		@Override
		public IconButtonConfiguration getConfiguration() {
			return config;
		}
    }
    public IconResult(A a, Variable property, AffineTransform transform) {
        super(a, property, transform);
    }
    public A getA() {
        return (A) getField(0);
    }
    public Variable getProperty() {
    	return (Variable) getField(1);
    }
    public AffineTransform getParentTransform() {
    	return (AffineTransform) getField(2);
    }
    public IconResult withValue(double value) {
    	return new IconResult(new A(value, getA().config), getProperty(), getParentTransform());
    }
	@Override
	public IconButtonState getState() {
		return getA();
	}
}