package org.simantics.diagram.profile;

import org.simantics.Simantics;
import org.simantics.datatypes.DatatypeResource;
import org.simantics.datatypes.literal.Vec2d;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.CommonDBUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.scl.commands.Commands;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.function.FunctionImpl1;

public class ElementTranslation {

    public static Function1<Vec2d, Boolean> function(final Resource element) {
        return new FunctionImpl1<Vec2d, Boolean>() {

            @Override
            public Boolean apply(final Vec2d delta) {
                Simantics.getSession().asyncRequest(new WriteRequest() {
                    @Override
                    public void perform(WriteGraph graph)
                            throws DatabaseException {
                        DiagramResource DIA = DiagramResource.getInstance(graph);
                        Vec2d offset = graph.getRelatedValue(element, DIA.Element_profileMonitorOffset, Vec2d.BINDING);
                        Commands.get(graph, "Simantics/Profile/setProfileMonitorPosition")
                        .execute(graph, graph.syncRequest(new IndexRoot(element)), element, 
                                offset.x+delta.x, offset.y+delta.y);
                    }
                });
                return null;
            }

        };
    }

    public static void setProfileMonitorPosition(WriteGraph graph, Resource element, double offsetX, double offsetY) throws DatabaseException {
    	CommonDBUtils.selectClusterSet(graph, element);
        DiagramResource DIA = DiagramResource.getInstance(graph);
        DatatypeResource DATA = DatatypeResource.getInstance(graph);
        Vec2d newOffset = new Vec2d(offsetX, offsetY);
        graph.claimLiteral(element, DIA.Element_profileMonitorOffset, DATA.Vec2d, newOffset, Vec2d.BINDING);
    }

    public static void resetProfileMonitorPosition(WriteGraph graph, Resource element) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance(graph);
        graph.deny(element, DIA.Element_profileMonitorOffset);
    }
}