/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.profile;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.modeling.ModelingResources;

/**
 * @author Tuukka Lehtonen
 */
public abstract class ComponentTextStyle extends TextStyle {

    public ComponentTextStyle() {
        super();
    }

    public ComponentTextStyle(double xOffset, double yOffset) {
        super(xOffset, yOffset);
    }

    @Override
    protected Resource getConfigurationComponent(ReadGraph graph, Resource element) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance(graph);
        Resource component = graph.getPossibleObject(element, MOD.ElementToComponent);
        if (component != null)
            return component;

        DiagramResource DIA = DiagramResource.getInstance(graph);
        if (graph.isInstanceOf(element, DIA.Flag) && FlagUtil.isExternal(graph, element)) {
            for (Resource connector : graph.getObjects(element, DIA.Flag_ConnectionPoint)) {
                Resource connection = ConnectionUtil.getConnection(graph, connector);
                component = graph.getPossibleObject(connection, MOD.ElementToComponent);
                if (component != null)
                    return component;
            }
        }
        return null;
    }

}