/*******************************************************************************
 * Copyright (c) 2007 VTT Technical Research Centre of Finland and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.handler;


import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.IPage;
import org.simantics.diagram.symbollibrary.ui.SymbolLibraryPage;
import org.simantics.diagram.symbollibrary.ui.SymbolPageView;

public class ExpandAll extends AbstractHandler implements IHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {

    	IWorkbenchPart part = HandlerUtil.getActivePart(event);
    	if(part == null) return null;
    	if(part instanceof SymbolPageView) {
    		SymbolPageView view = (SymbolPageView)part;
    		IPage page = view.getCurrentPage();
    		if(page == null) return null;
    		if(page instanceof SymbolLibraryPage) {
    			SymbolLibraryPage libraryPage = (SymbolLibraryPage)page;
    			libraryPage.setAllExpandedStates(true);
    		}
    	}
    	
        return null;
        
    }

}
