package org.simantics.diagram.flag;

import java.util.ArrayList;

import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.scl.runtime.tuple.Tuple2;

public class IOTablesInfo {
    public static final IOTablesInfo EMPTY = new IOTablesInfo();
    
    ArrayList<IOTableInfo> tables = new ArrayList<IOTableInfo>();

    public Tuple2 getBindingRef(double x, double y) {
        for(IOTableInfo table : tables) {
            if(x < table.x || x > table.x + table.width)
                continue;
            return new Tuple2(table.name, (int)((y-table.y)/table.rowHeight));
        }
        return null;
    }

    public boolean updateBinding(WriteGraph graph, DiagramResource DIA, Resource flagResource, double flagX, double flagY) throws DatabaseException {
        Tuple2 bindingRef = getBindingRef(flagX, flagY);
        
        if(bindingRef != null) {
            graph.claimLiteral(flagResource, DIA.Flag_HasIOTableBinding, (String)bindingRef.c0, Bindings.STRING);
            graph.claimLiteral(flagResource, DIA.Flag_HasIOTableRowIndex, (Integer)bindingRef.c1, Bindings.INTEGER);
            return true;
        }
        else {
            String currentBinding = graph.getPossibleRelatedValue(flagResource,  DIA.Flag_HasIOTableBinding);
            if(currentBinding != null && !currentBinding.isEmpty()) {
                graph.claimLiteral(flagResource, DIA.Flag_HasIOTableBinding, "", Bindings.STRING);
                double[] transform = graph.getRelatedValue(flagResource, DIA.HasTransform, Bindings.DOUBLE_ARRAY);
                transform[4] = flagX;
                transform[5] = flagY;
                graph.claimLiteral(flagResource, DIA.HasTransform, transform);
                return true;
            }
            return false;
        }
    } 
}
