/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.elements;

import java.awt.Point;

import org.simantics.g2d.image.Image;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.utils.datastructures.cache.IFactory;
import org.simantics.utils.datastructures.cache.ProvisionException;

/**
 * This is a SVG implementation to the PaintableSymbol interface.
 */
public class SVGImage extends org.simantics.g2d.svg.SVGImage {

    public SVGImage(String nodeIdentifier, String document, Point targetSize) {
        super(nodeIdentifier, document, targetSize);
    }

    public SVGImage(String nodeIdentifier, String document) {
        super(nodeIdentifier, document);
	}

    public static IFactory<Image> createFactoryFromString(String nodeIdentifier, String svgDocument, Point targetSize) {
        return new SVGFactory(nodeIdentifier, svgDocument, targetSize);
    }

    static class SVGFactory implements IFactory<Image> {
        String nodeIdentifier;
        String document;
        Point targetSize;
        public SVGFactory(String nodeIdentifier, String document) {
            this(nodeIdentifier, document, null);
        }
        public SVGFactory(String nodeIdentifier, String document, Point referenceSize) {
            if (nodeIdentifier == null)
                throw new NullPointerException("nodeIdentifier is null");
            if (document == null)
                throw new NullPointerException("document is null");

            this.nodeIdentifier = nodeIdentifier;
            this.document = document;
            this.targetSize = referenceSize;
        }
        @Override
        public Image get() throws ProvisionException {
            return new SVGImage(nodeIdentifier, document, targetSize);
        }
        @Override
        public boolean equals(Object obj) {
            if (this == obj)
                return true;
            if (obj == null)
                return false;
            if (!obj.getClass().equals(getClass()))
                return false;

            SVGFactory other = (SVGFactory)obj;

            if (!nodeIdentifier.equals(other.nodeIdentifier))
                return false;
            if (targetSize != null) {
                if (!targetSize.equals(other.targetSize))
                    return false;
            } else {
                if (other.targetSize != null)
                    return false;
            }

            return document.equals(other.document);
        }
        @Override
        public int hashCode() {
            return nodeIdentifier.hashCode() * 31 + document.hashCode() + 123;
        }
    }

    @Override
    public Node init(G2DParentNode parent) {
        // FIXME: mipmaps enabled here by default, since some apps just don't work without them.
        // Figure out a way to pass the mipmap argument from above

        SVGNode node = parent.getOrCreateNode(nodeIdentifier, SVGNode.class);
        node.setData(svgDocument);
        node.setTargetSize(targetSize);
        node.useMipMap(true);

        return node;
    }

}
