/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.connection;

import java.awt.Color;
import java.awt.Stroke;
import java.util.Arrays;

import org.simantics.g2d.element.handler.EdgeVisuals.StrokeType;

/**
 * @author Tuukka Lehtonen
 */
public class ConnectionVisuals {

    public final float[] color;
    public final StrokeType strokeType;
    public final Stroke stroke;
    public final Double branchPointRadius;
    public final Double rounding;
    public final Double offset;

    public ConnectionVisuals(float[] color, StrokeType strokeType, Stroke stroke, Double rounding) {
    	this(color, strokeType, stroke, null, rounding);
    }

    public ConnectionVisuals(float[] color, StrokeType strokeType, Stroke stroke, Double branchPointRadius, Double rounding) {
        this(color, strokeType, stroke, null, rounding, null);
    }

    public ConnectionVisuals(float[] color, StrokeType strokeType, Stroke stroke, Double branchPointRadius, Double rounding, Double offset) {
        if (color != null && color.length < 3)
            throw new IllegalArgumentException("colors must have at least 3 components (rgb), got " + color.length);
        this.color = color;
        this.strokeType = strokeType;
        this.stroke = stroke;
        this.branchPointRadius = branchPointRadius;
        this.rounding = rounding;
        this.offset = offset;
    }

    public Color toColor() {
        if (color == null)
            return null;
        if (color.length == 3)
            return new Color(color[0], color[1], color[2]);
        return new Color(color[0], color[1], color[2], color[3]);
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((branchPointRadius == null) ? 0 : branchPointRadius.hashCode());
        result = prime * result + Arrays.hashCode(color);
        result = prime * result + ((rounding == null) ? 0 : rounding.hashCode());
        result = prime * result + ((offset == null) ? 0 : offset.hashCode());
        result = prime * result + ((stroke == null) ? 0 : stroke.hashCode());
        result = prime * result + ((strokeType == null) ? 0 : strokeType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        ConnectionVisuals other = (ConnectionVisuals) obj;
        if (branchPointRadius == null) {
            if (other.branchPointRadius != null)
                return false;
        } else if (!branchPointRadius.equals(other.branchPointRadius))
            return false;
        if (!Arrays.equals(color, other.color))
            return false;
        if (rounding == null) {
            if (other.rounding != null)
                return false;
        } else if (!rounding.equals(other.rounding))
            return false;
        if (offset == null) {
            if (other.offset != null)
                return false;
        } else if (!offset.equals(other.offset))
            return false;
        if (stroke == null) {
            if (other.stroke != null)
                return false;
        } else if (!stroke.equals(other.stroke))
            return false;
        if (strokeType != other.strokeType)
            return false;
        return true;
    }
}
