/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.adapter;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.ServiceException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.ElementWriter;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;

/**
 * ElementWriter for TextElements
 * 
 * This inserts '[empty]' as default string. Without this, There is no way to edit
 * the text using PropertyPage, and with empty string its difficult to spot the text element.
 * 
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class TextElementWriter implements ElementWriter {

    @Override
    public void addToGraph(WriteGraph g, IElement element, Resource elementResource) throws ManyObjectsForFunctionalRelationException, ServiceException {
        DiagramResource dr = DiagramResource.getInstance(g);
        if (g.getPossibleRelatedValue(elementResource, dr.HasText) == null) {
        	String text = ElementUtils.getText(element);
        	if (text == null)
        		text = "[empty]";
            g.claimLiteral(elementResource,dr.HasText, text);
        }
    }

    @Override
    public void removeFromGraph(WriteGraph g, Resource elementResource) {
    }

}
