/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.adapter;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;
import org.simantics.datatypes.literal.Font;
import org.simantics.datatypes.literal.RGB;
import org.simantics.g2d.utils.Alignment;

/**
 * @author Teemu M&auml;t&auml;sniemi
 * @author Tuukka Lehtonen
 */
public class FlagTextInfo extends Bean {

    public static final Binding BINDING = Bindings.getBindingUnchecked(FlagTextInfo.class);

    public String id;

    @Optional
    public Font font;
    @Optional
    public RGB.Integer color;
    @Optional
    public String text;

    @Optional
    public double[] transform;

    public Alignment hAlignment;
    public Alignment vAlignment;

    public float width = -1.0f;
    public float borderWidth = -1.0f;
    public boolean wrapText = true;

    @Optional
    public RGB.Integer borderColor;
    @Optional
    public RGB.Integer backgroundColor;

    public FlagTextInfo() {
        super(BINDING);
    }

}
