/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.adapter;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.IElement;

/**
 * @author Tuukka Lehtonen
 */
public class ElementFactoryAdapter implements ElementFactory {

    @Override
    public void create(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType,
            AsyncProcedure<ElementClass> procedure) {
        procedure.exception(graph, new UnsupportedOperationException(getClass().getName() + " does not support ElementFactory.create"));
    }

    protected Resource getElementClassBaseType(AsyncReadGraph graph) {
        return graph.getService(DiagramResource.class).Element;
    }

    @Override
    public void getClass(AsyncReadGraph graph, final ICanvasContext canvas, final IDiagram diagram,
            Resource elementResource, final AsyncProcedure<ElementClass> procedure) {
        // A most usual default implementation.
        graph.forSingleType(elementResource, getElementClassBaseType(graph), new AsyncProcedure<Resource>() {
            @Override
            public void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }
            @Override
            public void execute(AsyncReadGraph graph, Resource elementType) {
                // Implements caching of element class requests.
                graph.asyncRequest(new CreateElementClassRequest(ElementFactoryAdapter.this, elementType, canvas, diagram),
                        new TransientCacheAsyncListener<ElementClass>() {
                    @Override
                    public void exception(AsyncReadGraph graph, Throwable t) {
                        procedure.exception(graph, t);
                    }
                    @Override
                    public void execute(AsyncReadGraph graph, ElementClass result) {
                        //System.out.println("RESULT ELEMENTCLASS: " + System.identityHashCode(result) + ": " + result);
                        procedure.execute(graph, result);
                    }
                });
            }
        });
    }

    @Override
    public void load(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementResource,
            IElement element, AsyncProcedure<IElement> procedure) {
        procedure.exception(graph, new UnsupportedOperationException(getClass().getName() + " does not support ElementFactory.load"));
    }

}
