package org.simantics.diagram.adapter;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

import org.simantics.g2d.connection.handler.ConnectionHandler;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.Resize;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.image.Image;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.utils.datastructures.hints.IHintContext.Key;

public class DefinedElementHandler implements SceneGraph, InternalSize, Resize, Outline {

	private static final long serialVersionUID = -2074850877791708846L;

	public static final DefinedElementHandler INSTANCE = new DefinedElementHandler();

    public static final Key  KEY_SG_NODE             = new SceneGraphNodeKey(Node.class, "IMAGE_SG_NODE");

    protected Image getImage(IElement e) {
        Image i = e.getHint(ElementHints.KEY_IMAGE);
        if (i == null)
            throw new IllegalStateException("element " + e + " has no ElementHints.KEY_IMAGE hint");
        return i;
    }

    protected Key getNodeKey() {
        return KEY_SG_NODE;
    }

    @Override
    public void init(final IElement e, final G2DParentNode parent) {
        Image i = getImage(e);
        Node node = i.init(parent);
        if (node != null)
            e.setHint(getNodeKey(), node);
        if(node instanceof IG2DNode) {
        	IG2DNode n = (IG2DNode)node;
        	AffineTransform at = ElementUtils.getTransform(e);
        	if(at != null) {
        		n.setTransform(at); // FIXME: not tested..
        	}
        }
        if(parent instanceof SingleElementNode) {
            ((SingleElementNode)parent).setParameters(ElementUtils.getParameters(e));
        }
    }

    public void cleanup(final IElement e) {
        Node node = e.removeHint(getNodeKey());
        if (node != null)
            node.remove();
    }
    
    protected Rectangle2D imageBounds(IElement e, Rectangle2D size) {
        Image i = e.getHint(ElementHints.KEY_IMAGE);
        if (i == null)
            return size;
        Rectangle2D r = i.getBounds();
        if (r != null) {
            if (size == null)
                size = new Rectangle2D.Double();
            size.setFrame(r);
        }
        return size;
    }

    @Override
    public Rectangle2D getBounds(IElement e, Rectangle2D size) {
        ElementClass ec = e.getElementClass();
        if (ec.containsClass(ConnectionHandler.class)) {
            size = imageBounds(e, size);
        } else {
            IG2DNode node = e.getHint(getNodeKey());
            Rectangle2D r = node != null ? node.getBoundsInLocal() : null;
            if (r != null) {
                if (size == null)
                    size = new Rectangle2D.Double();
                size.setFrame(r);
            } else {
                size = imageBounds(e, size);
            }
        }

        return size;
    }

    @Override
    public Double getFixedAspectRatio(IElement e) {
        Image i = getImage(e);
        Rectangle2D r = i.getBounds();
        return r.getWidth() / r.getHeight();
    }

    @Override
    public Rectangle2D getMaximumSize(IElement e) {
        Image i = getImage(e);
        return i.getBounds();
    }

    @Override
    public Rectangle2D getMinimumSize(IElement e) {
        Image i = getImage(e);
        return i.getBounds();
    }

    @Override
    public void resize(IElement e, Rectangle2D newSize) {
    }

    @Override
    public Shape getElementShape(IElement e) {
        IG2DNode node = e.getHint(getNodeKey());
        if (node != null) {
            Rectangle2D bounds = node.getBoundsInLocal();
            if (bounds != null)
                return bounds;
        }
        // Fallback to old logic.
        Image i = getImage(e);
        return i.getOutline();
    }
	
}